/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.societytrading.trading;

import dev.latvian.mods.kubejs.stages.Stages;
import io.github.chakyl.societytrading.SocietyTrading;
import java.util.List;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import sereneseasons.api.season.SeasonHelper;

public class ShopOffer {
    private final ItemStack costA;
    private final ItemStack costB;
    private final ItemStack result;
    private final String stageRequired;
    private final String stageOverride;
    private final List<String> seasonsRequired;
    private final int numismaticsCost;
    MutableComponent unlockDescription;

    public ShopOffer(ItemStack pCostA, ItemStack pResult, MutableComponent pUnlockDescription, String pStageRequired, String pStageOverride, List<String> pSeasonsRequired, int pNumismaticsCost) {
        this(pCostA, ItemStack.f_41583_, pResult, pUnlockDescription, pStageRequired, pStageOverride, pSeasonsRequired, pNumismaticsCost);
    }

    public ShopOffer(ItemStack pCostA, ItemStack pCostB, ItemStack pResult, MutableComponent pUnlockDescription, String pStageRequired, String pStageOverride, List<String> pSeasonsRequired, int pNumismaticsCost) {
        this.costA = pCostA;
        this.costB = pCostB;
        this.result = pResult;
        this.stageRequired = pStageRequired;
        this.stageOverride = pStageOverride;
        this.seasonsRequired = pSeasonsRequired;
        this.numismaticsCost = pNumismaticsCost;
        this.unlockDescription = pUnlockDescription;
    }

    public ItemStack getCostA() {
        return this.costA;
    }

    public ItemStack getCostB() {
        return this.costB;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public String getStageRequired() {
        return this.stageRequired;
    }

    public String getStageOverride() {
        return this.stageOverride;
    }

    public MutableComponent getUnlockDescription() {
        return this.unlockDescription;
    }

    public List<String> getSeasonsRequired() {
        return this.seasonsRequired;
    }

    public boolean hasNumismaticsCost() {
        return this.numismaticsCost > 0;
    }

    public int getNumismaticsCost() {
        return this.numismaticsCost;
    }

    public boolean playerCanSee(Player player) {
        if (SocietyTrading.KUBEJS_INSTALLED) {
            if (!this.stageOverride.isEmpty() && Stages.get((Player)player).has(this.stageOverride)) {
                return true;
            }
            if (!this.stageRequired.isEmpty() && !Stages.get((Player)player).has(this.stageRequired)) {
                return false;
            }
        }
        return !SocietyTrading.SERENE_SEASONS_INSTALLED || this.seasonsRequired.isEmpty() || this.seasonsRequired.contains(SeasonHelper.getSeasonState((Level)player.m_9236_()).getSubSeason().m_7912_());
    }

    public boolean satisfiedBy(ItemStack pPlayerOfferA, ItemStack pPlayerOfferB) {
        return this.isRequiredItem(pPlayerOfferA, this.getCostA()) && pPlayerOfferA.m_41613_() >= this.getCostA().m_41613_() && this.isRequiredItem(pPlayerOfferB, this.costB) && pPlayerOfferB.m_41613_() >= this.costB.m_41613_();
    }

    private boolean isRequiredItem(ItemStack pOffer, ItemStack pCost) {
        if (pCost.m_41619_() && pOffer.m_41619_()) {
            return true;
        }
        ItemStack itemstack = pOffer.m_41777_();
        if (itemstack.m_41720_().isDamageable(itemstack)) {
            itemstack.m_41721_(itemstack.m_41773_());
        }
        return ItemStack.m_41656_((ItemStack)itemstack, (ItemStack)pCost) && (!pCost.m_41782_() || itemstack.m_41782_() && NbtUtils.m_129235_((Tag)pCost.m_41783_(), (Tag)itemstack.m_41783_(), (boolean)false));
    }

    public boolean take(ItemStack pPlayerOfferA, ItemStack pPlayerOfferB) {
        if (!this.satisfiedBy(pPlayerOfferA, pPlayerOfferB)) {
            return false;
        }
        pPlayerOfferA.m_41774_(this.getCostA().m_41613_());
        if (!this.getCostB().m_41619_()) {
            pPlayerOfferB.m_41774_(this.getCostB().m_41613_());
        }
        return true;
    }
}

