/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.societytrading.events;

import io.github.chakyl.societytrading.data.Shop;
import io.github.chakyl.societytrading.data.ShopRegistry;
import io.github.chakyl.societytrading.registry.ModElements;
import io.github.chakyl.societytrading.screen.SelectorMenu;
import io.github.chakyl.societytrading.screen.ShopMenu;
import io.github.chakyl.societytrading.util.GeneralUtils;
import io.github.chakyl.societytrading.util.ShopData;
import java.util.OptionalInt;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.NameTagItem;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;

public class ServerEvents {

    @Mod.EventBusSubscriber(modid="society_trading", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEvents {
        @SubscribeEvent
        public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
            Shop shop;
            Player player = event.getEntity();
            Entity target = event.getTarget();
            if (player instanceof ServerPlayer && target instanceof LivingEntity && (shop = ShopData.getShopFromEntity(ShopRegistry.INSTANCE.getValues(), (LivingEntity)target)) != null) {
                if (event.getItemStack().m_41720_() instanceof NameTagItem) {
                    GeneralUtils.nameTagEntity(event.getItemStack(), player, (LivingEntity)target);
                }
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((containerId, inventory, nPlayer) -> new ShopMenu(containerId, inventory, shop.shopID()), (Component)shop.name()), buffer -> buffer.m_130070_(shop.shopID()));
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onVillagerInteract(PlayerInteractEvent.EntityInteract event) {
            Player player = event.getEntity();
            Entity villager = event.getTarget();
            if (player instanceof ServerPlayer && villager instanceof Villager) {
                VillagerData data = ((Villager)villager).m_7141_();
                Shop shop = ShopData.getShopFromVillagerProfession(ShopRegistry.INSTANCE.getValues(), data.m_35571_().f_35600_());
                if (shop != null) {
                    if (event.getItemStack().m_41720_() instanceof NameTagItem) {
                        GeneralUtils.nameTagEntity(event.getItemStack(), player, (LivingEntity)villager);
                    }
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((containerId, inventory, nPlayer) -> new ShopMenu(containerId, inventory, shop.shopID()), (Component)shop.name()), buffer -> buffer.m_130070_(shop.shopID()));
                    int experience = ((Villager)villager).m_7809_();
                    ((Villager)villager).m_35546_(experience > 0 ? experience : 1);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
            Player player = event.getEntity();
            BlockState clickedBlock = event.getLevel().m_8055_(event.getPos());
            if (player instanceof ServerPlayer && !player.m_9236_().f_46443_) {
                Shop shop;
                if (clickedBlock.m_204336_(ModElements.Tags.OPENS_SHOP_SELECTOR)) {
                    OptionalInt optionalint = ((ServerPlayer)player).m_5893_((MenuProvider)new SimpleMenuProvider((containerId, inventory, nPlayer) -> new SelectorMenu(containerId, inventory), (Component)Component.m_237115_((String)"shop.society_trading.selector.name")));
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                }
                if ((shop = ShopData.getShopFromBlockState(ShopRegistry.INSTANCE.getValues(), clickedBlock)) != null) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((containerId, inventory, nPlayer) -> new ShopMenu(containerId, inventory, shop.shopID()), (Component)shop.name()), buffer -> buffer.m_130070_(shop.shopID()));
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                }
            }
        }
    }
}

