/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.societytrading.data;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import io.github.chakyl.societytrading.SocietyTrading;
import io.github.chakyl.societytrading.data.Shop;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public class ShopRegistry
extends DynamicRegistry<Shop> {
    public static final ShopRegistry INSTANCE = new ShopRegistry();
    private Map<String, Shop> shopsByID = new HashMap<String, Shop>();

    public ShopRegistry() {
        super(SocietyTrading.LOGGER, "shops", true, false);
    }

    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(new ResourceLocation("society_trading", "shops"), Shop.CODEC);
    }

    protected void beginReload() {
        super.beginReload();
        this.shopsByID = new HashMap<String, Shop>();
    }

    protected void onReload() {
        super.onReload();
        this.shopsByID = ImmutableMap.copyOf(this.shopsByID);
    }

    protected void validateItem(ResourceLocation key, Shop shop) {
        shop.validate(key);
        if (this.shopsByID.containsKey(shop.shopID())) {
            String msg = "Attempted to register two shops (%s and %s) with the same shopID: %s!";
            throw new UnsupportedOperationException(String.format(msg, key, this.getKey(this.shopsByID.get(shop.shopID())), shop.shopID()));
        }
        this.shopsByID.put(shop.shopID(), shop);
    }

    public Map<ResourceLocation, JsonElement> m_5944_(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        return super.m_5944_(pResourceManager, pProfiler);
    }
}

