/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.societytrading.JEI;

import io.github.chakyl.societytrading.JEI.TradeRecipe;
import io.github.chakyl.societytrading.util.ShopData;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class TradesCategory
implements IRecipeCategory<TradeRecipe> {
    public static final RecipeType<TradeRecipe> TYPE = RecipeType.create((String)"society_trading", (String)"trade", TradeRecipe.class);
    public static final ResourceLocation TRADE_TEXTURE = new ResourceLocation("society_trading", "textures/jei/trade.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final Component name;

    public TradesCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TRADE_TEXTURE, 0, 0, 128, 56);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.f_42616_));
        this.name = Component.m_237115_((String)"jei.society_trading.category.trades");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Component getTitle() {
        return this.name;
    }

    public RecipeType<TradeRecipe> getRecipeType() {
        return TYPE;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TradeRecipe recipe, IFocusGroup focuses) {
        int priceOffset = 53;
        if (!recipe.hideCostA) {
            builder.addSlot(RecipeIngredientRole.INPUT, !recipe.costB.m_41619_() && recipe.hideCostB ? priceOffset : 45, 21).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.costA);
        }
        if (!recipe.costB.m_41619_() && !recipe.hideCostB) {
            builder.addSlot(RecipeIngredientRole.INPUT, recipe.hideCostA ? priceOffset : 21, 21).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.costB);
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, 0, 0).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.catalyst);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 101, 21).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.result);
    }

    public void draw(TradeRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        guiGraphics.m_280649_(Minecraft.m_91087_().f_91062_, Language.m_128107_().m_5536_((FormattedText)recipe.shopName), 19, 4, 0x404040, false);
        if (recipe.numismaticsCost > 0) {
            boolean replaced = recipe.hideCostA && recipe.hideCostB;
            MutableComponent priceStr = Component.m_237110_((String)"jei.society_trading.price", (Object[])new Object[]{ShopData.formatPrice(Integer.valueOf(recipe.numismaticsCost).toString())});
            guiGraphics.m_280649_(Minecraft.m_91087_().f_91062_, Language.m_128107_().m_5536_((FormattedText)priceStr), replaced ? 58 - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)priceStr) : 5, 25, 0xFFFFFF, true);
        }
        if (!Objects.equals(recipe.unlockDescription, Component.m_237119_())) {
            guiGraphics.m_280649_(Minecraft.m_91087_().f_91062_, Language.m_128107_().m_5536_((FormattedText)recipe.unlockDescription), 2, 46, 0x404040, false);
        }
    }
}

