/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.wreath_stuff.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.reg.ModMemoryModules;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.mehvahdjukaar.snowyspirit.wreath_stuff.WreathHelper;
import net.mehvahdjukaar.snowyspirit.wreath_stuff.capabilities.ModCapabilities;
import net.mehvahdjukaar.snowyspirit.wreath_stuff.capabilities.WreathCapability;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;

public class PlaceWreathTask
extends Behavior<Villager> {
    private final float speedModifier;
    private BlockPos targetPos;
    private int ticksSinceReached = 0;
    private int cooldown = 400;

    public PlaceWreathTask(float speed) {
        super((Map)ImmutableMap.of(ModMemoryModules.WREATH_POS.get(), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), 190, 270);
        this.speedModifier = speed;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        if (this.cooldown-- > 0) {
            return false;
        }
        if (pOwner.m_6162_()) {
            return false;
        }
        if (!SnowySpirit.isChristmasSeason(pOwner.m_9236_())) {
            return false;
        }
        if (!ForgeEventFactory.getMobGriefingEvent((Level)pLevel, (Entity)pOwner)) {
            this.cooldown = 1200;
            return false;
        }
        return true;
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        this.cooldown = 8 * (10 + pLevel.f_46441_.m_188503_(10)) + pLevel.f_46441_.m_188503_(20);
        this.ticksSinceReached = 0;
        this.targetPos = PlaceWreathTask.getValidPlacementPos(pLevel, (LivingEntity)pEntity);
        if (this.targetPos != null) {
            pEntity.m_6274_().m_21936_(MemoryModuleType.f_26374_);
            pEntity.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(this.targetPos, this.speedModifier, 1));
            PlaceWreathTask.displayAsHeldItem(pEntity, ModRegistry.WREATH.get().m_5456_().m_7968_());
        }
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.m_6732_(pLevel, (LivingEntity)pEntity, pGameTime);
        PlaceWreathTask.clearHeldItem(pEntity);
        this.targetPos = null;
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return this.targetPos != null && PlaceWreathTask.isValidPlacementSpot(pLevel, this.targetPos);
    }

    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        if (this.targetPos != null) {
            pOwner.m_6274_().m_21936_(MemoryModuleType.f_26374_);
            pOwner.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(this.targetPos, this.speedModifier, 2));
            pOwner.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.targetPos));
            if (this.targetPos.m_203195_((Position)pOwner.m_20182_(), 2.3)) {
                ++this.ticksSinceReached;
                if (this.ticksSinceReached > 20) {
                    if (WreathHelper.placeWreathOnDoor(this.targetPos, (Level)pLevel)) {
                        pOwner.m_6274_().m_21879_(ModMemoryModules.WREATH_POS.get(), (Object)GlobalPos.m_122643_((ResourceKey)pLevel.m_46472_(), (BlockPos)this.targetPos));
                    }
                    this.targetPos = null;
                }
            }
        }
    }

    @Nullable
    private static BlockPos getValidPlacementPos(ServerLevel pLevel, LivingEntity pWalker) {
        RandomSource random = pWalker.m_217043_();
        BlockPos targetPos = pWalker.m_20183_();
        for (int i = 0; i < 6; ++i) {
            BlockPos pos = targetPos.m_7918_(random.m_188503_(20) - 10, random.m_188503_(6) - 3, random.m_188503_(20) - 10);
            if (!PlaceWreathTask.isValidPlacementSpot(pLevel, pos)) continue;
            return pos;
        }
        return null;
    }

    public static boolean isValidPlacementSpot(ServerLevel serverLevel, BlockPos pos) {
        BlockState state = serverLevel.m_8055_(pos);
        if (state.m_60734_() instanceof DoorBlock) {
            boolean lower = state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER;
            WreathCapability c = ModCapabilities.get((ICapabilityProvider)serverLevel, ModCapabilities.WREATH_CAPABILITY);
            return c != null && (lower ? !c.hasWreath(pos.m_7494_()) : !c.hasWreath(pos));
        }
        return false;
    }

    public static void clearHeldItem(Villager self) {
        self.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        self.m_21409_(EquipmentSlot.MAINHAND, 0.085f);
    }

    public static void displayAsHeldItem(Villager self, ItemStack stack) {
        self.m_8061_(EquipmentSlot.MAINHAND, stack);
        self.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }
}

