/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.entity;

import dev.architectury.injectables.annotations.PlatformOnly;
import net.mehvahdjukaar.moonlight.api.entity.IExtraClientSpawnData;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.integration.supp.SuppCompat;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.mehvahdjukaar.snowyspirit.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class ContainerHolderEntity
extends Entity
implements Container,
IExtraClientSpawnData,
MenuProvider {
    private static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.m_135353_(ContainerHolderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.m_135353_(ContainerHolderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private ItemStack containerStack = ItemStack.f_41583_;
    private BlockState displayState = Blocks.f_50016_.m_49966_();
    private BaseContainerBlockEntity innerBlockEntity;

    public ContainerHolderEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.f_19850_ = true;
    }

    protected ContainerHolderEntity(Level level, Entity sled, ItemStack containerStack) {
        this(ModRegistry.CONTAINER_ENTITY.get(), level);
        this.setContainerItem(containerStack);
        this.m_146884_(sled.m_20182_());
        if (this.m_20329_(sled)) {
            sled.m_7332_((Entity)this);
        }
    }

    public BlockState getDisplayState() {
        return this.displayState;
    }

    public void setContainerItem(ItemStack stack) {
        CompoundTag tag;
        EntityBlock eb;
        BlockEntity blockEntity;
        BlockItem bi;
        Block block;
        this.containerStack = stack;
        Item item = this.containerStack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            this.displayState = blockItem.m_40614_().m_49966_();
        }
        if ((item = stack.m_41720_()) instanceof BlockItem && (block = (bi = (BlockItem)item).m_40614_()) instanceof EntityBlock && (blockEntity = (eb = (EntityBlock)block).m_142194_(BlockPos.f_121853_, block.m_49966_())) instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity c;
            this.innerBlockEntity = c = (BaseContainerBlockEntity)blockEntity;
            this.innerBlockEntity.m_142339_(this.m_9236_());
        }
        if (this.innerBlockEntity == null) {
            throw new IllegalStateException("block {} does not provide a valid container block entity");
        }
        if (ContainerHolderEntity.isContainerWithNBT(stack) && stack.m_41782_() && (tag = stack.m_41737_("BlockEntityTag")) != null) {
            this.innerBlockEntity.m_142466_(tag);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return PlatHelper.getEntitySpawnPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.containerStack);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.setContainerItem(additionalData.m_130267_());
    }

    protected void m_7378_(CompoundTag tag) {
        this.setContainerItem(ItemStack.m_41712_((CompoundTag)tag.m_128469_("ContainerItem")));
        if (this.innerBlockEntity == null) {
            boolean bl = true;
        } else {
            this.innerBlockEntity.m_142466_(tag);
        }
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128365_("ContainerItem", (Tag)this.containerStack.m_41739_(new CompoundTag()));
        tag.m_128391_(this.innerBlockEntity.m_187482_());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_HURT, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public double m_6049_() {
        return 0.0;
    }

    protected float m_6380_(Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_ * 0.5f;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    /*
     * Unable to fully structure code
     */
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        block6: {
            if (this.m_9236_().f_46443_ || this.m_213877_()) break block6;
            if (this.m_6673_(pSource)) {
                return false;
            }
            this.setHurtTime(10);
            this.m_5834_();
            this.setDamage(this.getDamage() + pAmount * 10.0f);
            this.m_146852_(GameEvent.f_223706_, pSource.m_7639_());
            var5_3 = pSource.m_7639_();
            if (!(var5_3 instanceof Player)) ** GOTO lbl-1000
            player = (Player)var5_3;
            if (player.m_150110_().f_35937_) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = flag = false;
            }
            if (flag || this.getDamage() > 15.0f) {
                this.m_20153_();
                if (flag && !this.m_8077_()) {
                    this.m_146870_();
                } else {
                    this.destroy(pSource);
                }
            }
        }
        return true;
    }

    public void destroy(DamageSource pSource) {
        Entity entity;
        Level level = this.m_9236_();
        if (level.m_46469_().m_46207_(GameRules.f_46137_) && !level.f_46443_ && (entity = pSource.m_7640_()) != null && entity.m_6095_() == EntityType.f_20532_) {
            PiglinAi.m_34873_((Player)((Player)entity), (boolean)true);
        }
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public void spawnDrops() {
        ItemStack stack = this.containerStack.m_41777_();
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        if (ContainerHolderEntity.isContainerWithNBT(this.containerStack)) {
            stack.m_41700_("BlockEntityTag", (Tag)this.innerBlockEntity.m_187482_());
        } else {
            Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this.innerBlockEntity);
        }
        this.m_19983_(stack);
    }

    public void m_6053_(float hurtYaw) {
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + this.getDamage() * 10.0f);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_8119_() {
        Entity v = this.m_20202_();
        if (v != null) {
            if (this.getHurtTime() > 0) {
                this.setHurtTime(this.getHurtTime() - 1);
            }
            if (this.getDamage() > 0.0f) {
                this.setDamage(this.getDamage() - 1.0f);
            }
            this.m_146871_();
            this.m_20157_();
            super.m_8119_();
        } else {
            this.destroy(this.m_269291_().m_269264_());
        }
    }

    public void setDamage(float pDamage) {
        this.f_19804_.m_135381_(DATA_ID_DAMAGE, (Object)Float.valueOf(pDamage));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_DAMAGE)).floatValue();
    }

    public void setHurtTime(int pRollingAmplitude) {
        this.f_19804_.m_135381_(DATA_ID_HURT, (Object)pRollingAmplitude);
    }

    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURT);
    }

    @PlatformOnly(value={"forge"})
    public ItemStack getPickedResult(HitResult target) {
        return this.containerStack.m_41777_();
    }

    public Component m_5446_() {
        return Component.m_237110_((String)"message.snowyspirit.container_entity_name", (Object[])new Object[]{this.containerStack.m_41720_().m_41466_().getString()});
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        if (!this.m_9236_().f_46443_ && pReason.m_146965_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            this.spawnDrops();
        }
        super.m_142687_(pReason);
    }

    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        InteractionResult ret = super.m_6096_(pPlayer, pHand);
        if (ret.m_19077_()) {
            return ret;
        }
        if (!pPlayer.m_9236_().f_46443_) {
            PlatHelper.openCustomMenu((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)this, b -> {
                b.writeBoolean(false);
                b.m_130130_(this.m_19879_());
            });
            this.m_146852_(GameEvent.f_157803_, (Entity)pPlayer);
            PiglinAi.m_34873_((Player)pPlayer, (boolean)true);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public float getWeightFromItems() {
        return (float)AbstractContainerMenu.m_38938_((Container)this.innerBlockEntity) / 15.0f;
    }

    public static boolean isValidContainer(ItemStack stack) {
        return ContainerHolderEntity.isNormalContainer(stack) || ContainerHolderEntity.isContainerWithNBT(stack);
    }

    private static boolean isNormalContainer(ItemStack stack) {
        return stack.m_204117_(ModTags.VALID_CONTAINERS) && stack.m_41720_() instanceof BlockItem;
    }

    private static boolean isContainerWithNBT(ItemStack stack) {
        Item i = stack.m_41720_();
        return ContainerHolderEntity.isShulkerBox(i) || ContainerHolderEntity.isSack(i);
    }

    private static boolean isShulkerBox(Item i) {
        BlockItem bi;
        return i instanceof BlockItem && (bi = (BlockItem)i).m_40614_() instanceof ShulkerBoxBlock;
    }

    private static boolean isSack(Item i) {
        return SnowySpirit.SUPPLEMENTARIES_INSTALLED && SuppCompat.isSack(i);
    }

    public int m_6643_() {
        return this.innerBlockEntity.m_6643_();
    }

    public boolean m_7983_() {
        return this.innerBlockEntity.m_7983_();
    }

    public ItemStack m_8020_(int slot) {
        return this.innerBlockEntity.m_8020_(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return this.innerBlockEntity.m_7407_(slot, amount);
    }

    public ItemStack m_8016_(int slot) {
        return this.innerBlockEntity.m_8016_(slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.innerBlockEntity.m_6836_(slot, stack);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        if (this.m_213877_()) {
            return false;
        }
        return player.m_20280_((Entity)this) <= 64.0;
    }

    public void m_6211_() {
        this.innerBlockEntity.m_6211_();
    }

    public void setLootTable(ResourceLocation res, long seed) {
        BaseContainerBlockEntity baseContainerBlockEntity = this.innerBlockEntity;
        if (baseContainerBlockEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity r = (RandomizableContainerBlockEntity)baseContainerBlockEntity;
            r.m_59626_(res, seed);
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory pPlayerInventory, Player player) {
        if (ContainerHolderEntity.isSack(this.containerStack.m_41720_())) {
            return SuppCompat.createSackMenu(id, pPlayerInventory, this);
        }
        if (!ContainerHolderEntity.isNormalContainer(this.containerStack)) {
            return new ShulkerBoxMenu(id, pPlayerInventory, (Container)this);
        }
        return ChestMenu.m_39237_((int)id, (Inventory)pPlayerInventory, (Container)this);
    }
}

