/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.block;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.block.IColored;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.snowyspirit.common.block.GlowLightsBlockTile;
import net.mehvahdjukaar.snowyspirit.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlowLightsBlock
extends WaterBlock
implements EntityBlock,
IColored {
    public final DyeColor color;
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    private static final Map<Direction, BooleanProperty> DIR_MAP = (Map)Util.m_137537_(() -> {
        EnumMap<Direction, BooleanProperty> m = new EnumMap<Direction, BooleanProperty>(Direction.class);
        m.put(Direction.UP, UP);
        m.put(Direction.DOWN, DOWN);
        m.put(Direction.WEST, WEST);
        m.put(Direction.SOUTH, SOUTH);
        m.put(Direction.EAST, EAST);
        m.put(Direction.NORTH, NORTH);
        return m;
    });

    public GlowLightsBlock(DyeColor color) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_).m_60953_(s -> 6));
        this.color = color;
    }

    public static boolean hasSide(BlockState state, Direction direction) {
        if (direction == null) {
            return true;
        }
        return (Boolean)state.m_61143_((Property)DIR_MAP.get(direction));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{UP});
        builder.m_61104_(new Property[]{DOWN});
        builder.m_61104_(new Property[]{EAST});
        builder.m_61104_(new Property[]{WEST});
        builder.m_61104_(new Property[]{SOUTH});
        builder.m_61104_(new Property[]{NORTH});
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        return (BlockState)super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos).m_61124_((Property)DIR_MAP.get(direction), (Comparable)Boolean.valueOf(!Block.m_49918_((VoxelShape)neighborState.m_60812_((BlockGetter)level, neighborPos), (Direction)direction.m_122424_())));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        for (Map.Entry<Direction, BooleanProperty> e : DIR_MAP.entrySet()) {
            Direction d = e.getKey();
            BlockPos p = pos.m_121945_(d);
            state = (BlockState)state.m_61124_((Property)e.getValue(), (Comparable)Boolean.valueOf(!Block.m_49918_((VoxelShape)level.m_8055_(p).m_60812_((BlockGetter)level, p), (Direction)d.m_122424_())));
        }
        return state;
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public boolean supportsBlankColor() {
        return true;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List drops = super.m_49635_(state, builder);
        Object object = builder.m_287261_(LootContextParams.f_81462_);
        if (object instanceof GlowLightsBlockTile) {
            GlowLightsBlockTile tile = (GlowLightsBlockTile)((Object)object);
            BlockState heldState = tile.getHeldBlock();
            Object object2 = builder.m_287261_(LootContextParams.f_81455_);
            if (object2 instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)object2;
                if (!ForgeHelper.canHarvestBlock((BlockState)heldState, (ServerLevel)builder.m_287258_(), (BlockPos)BlockPos.m_274446_((Position)((Position)builder.m_287261_(LootContextParams.f_81460_))), (ServerPlayer)player)) {
                    return drops;
                }
            }
            List newDrops = heldState.m_287290_(builder);
            drops.addAll(newDrops);
        }
        return drops;
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new GlowLightsBlockTile(pPos, pState);
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return Shapes.m_83040_();
    }

    public int m_7753_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 1;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!pLevel.m_46758_(pPos.m_7494_()) || pRandom.m_188503_(15) != 1 || (blockstate = pLevel.m_8055_(blockpos = pPos.m_7495_())).m_60815_() && blockstate.m_60783_((BlockGetter)pLevel, blockpos, Direction.UP))) {
            double d0 = (double)pPos.m_123341_() + pRandom.m_188500_();
            double d1 = (double)pPos.m_123342_() - 0.05;
            double d2 = (double)pPos.m_123343_() + pRandom.m_188500_();
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123803_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
        this.spawnParticlesOnBlockFaces(pLevel, pState, pPos, (ParticleOptions)ModRegistry.GLOW_LIGHT_PARTICLE.get(), pRandom, this.color);
    }

    public void spawnParticlesOnBlockFaces(Level level, BlockState state, BlockPos pos, ParticleOptions particleOptions, RandomSource randomSource, DyeColor color) {
        Vec3 vec3 = Vec3.m_82512_((Vec3i)pos);
        for (Direction direction : Direction.values()) {
            if (!(randomSource.m_188501_() < 0.15f) || !GlowLightsBlock.hasSide(state, direction)) continue;
            int i = direction.m_122429_();
            int j = direction.m_122430_();
            int k = direction.m_122431_();
            double d0 = vec3.f_82479_ + (i == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.5, (double)0.5) : (double)i * 0.6);
            double d1 = vec3.f_82480_ + (j == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.5, (double)0.5) : (double)j * 0.6);
            double d2 = vec3.f_82481_ + (k == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.5, (double)0.5) : (double)k * 0.6);
            float[] c = ClientDynamicResourcesHandler.getGlowLightColor(color, randomSource);
            level.m_7106_(particleOptions, d0, d1, d2, (double)c[0], (double)c[1], (double)c[2]);
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level level, BlockPos pos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack stack = pPlayer.m_21120_(pHand);
        if (stack.m_41720_() instanceof ShearsItem) {
            List<ItemStack> drops = this.shearAction(pPlayer, stack, level, pos, 0);
            drops.forEach(d -> {
                ItemEntity ent = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, d);
                ent.m_32060_();
                level.m_7967_((Entity)ent);
                RandomSource r = level.f_46441_;
                ent.m_20256_(ent.m_20184_().m_82520_((double)((r.m_188501_() - r.m_188501_()) * 0.1f), (double)(r.m_188501_() * 0.05f), (double)((r.m_188501_() - r.m_188501_()) * 0.1f)));
            });
            stack.m_41622_(1, (LivingEntity)pPlayer, e -> e.m_21190_(pHand));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(pState, level, pos, pPlayer, pHand, pHit);
    }

    private List<ItemStack> shearAction(@Nullable Player player, @NotNull ItemStack item, Level world, BlockPos pos, int fortune) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof GlowLightsBlockTile) {
            GlowLightsBlockTile tile = (GlowLightsBlockTile)blockEntity;
            if (!world.m_5776_()) {
                world.m_46597_(pos, tile.getHeldBlock());
                return Collections.singletonList(ModRegistry.GLOW_LIGHTS_ITEMS.get(this.color).get().m_7968_());
            }
        }
        return Collections.emptyList();
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return ModRegistry.GLOW_LIGHTS_ITEMS.get(this.color).get().m_7968_();
    }
}

