/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.ai;

import com.mojang.datafixers.util.Pair;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.mehvahdjukaar.moonlight.api.entity.VillagerAIHooks;
import net.mehvahdjukaar.moonlight.api.events.IVillagerBrainEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.common.ai.ThrowSnowballsTask;
import net.mehvahdjukaar.snowyspirit.common.ai.forge.WinterVillagerAIImpl;
import net.mehvahdjukaar.snowyspirit.integration.supp.PlacePresentTask;
import net.mehvahdjukaar.snowyspirit.reg.ModMemoryModules;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.schedule.Activity;

public class WinterVillagerAI {
    public static boolean PRESENTS_ENABLED = SnowySpirit.SUPPLEMENTARIES_INSTALLED && PlacePresentTask.isPresentOn();

    public static void setup() {
        MoonlightEventsHelper.addListener(WinterVillagerAI::onVillagerBrainInitialize, IVillagerBrainEvent.class);
        VillagerAIHooks.registerMemory(ModMemoryModules.PLACED_PRESENT.get());
        VillagerAIHooks.registerMemory(ModMemoryModules.WREATH_POS.get());
    }

    public static void onVillagerBrainInitialize(IVillagerBrainEvent event) {
        Villager villager = event.getVillager();
        if (SnowySpirit.isChristmasSeason(villager.m_9236_())) {
            if (villager.m_6162_()) {
                VillagerType t = villager.m_7141_().m_35560_();
                if (t == VillagerType.f_35823_ || t == VillagerType.f_35825_) {
                    event.addTaskToActivity(Activity.f_37981_, Pair.of((Object)4, (Object)((Object)new ThrowSnowballsTask(10))));
                }
            } else {
                if (PRESENTS_ENABLED) {
                    event.addTaskToActivity(Activity.f_37983_, Pair.of((Object)3, (Object)((Object)new PlacePresentTask(0.5f))));
                }
                WinterVillagerAI.addPlaceWreath(event);
            }
        } else if (!villager.m_6162_()) {
            WinterVillagerAI.addRemoveWreath(event);
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void addRemoveWreath(IVillagerBrainEvent event) {
        WinterVillagerAIImpl.addRemoveWreath(event);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void addPlaceWreath(IVillagerBrainEvent event) {
        WinterVillagerAIImpl.addPlaceWreath(event);
    }
}

