/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.client;

import net.mehvahdjukaar.snowyspirit.common.entity.SledEntity;
import net.mehvahdjukaar.snowyspirit.configs.ClientConfigs;
import net.mehvahdjukaar.snowyspirit.reg.ModSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;

public class SledSoundInstance
extends AbstractTickableSoundInstance {
    public static final int DELAY = 20;
    public static final float CUTOFF_SPEED = 0.05f;
    public static final int SPEED_DIVIDER = 25;
    private final SledEntity sled;
    private int time;
    private int fastTime;
    private final boolean isSnow;
    private int ticksOnSnow = 0;

    public SledSoundInstance(SledEntity sledEntity, boolean isSnow) {
        super(isSnow ? ModSounds.SLED_SOUND_SNOW.get() : ModSounds.SLED_SOUND.get(), SoundSource.PLAYERS, sledEntity.m_9236_().m_213780_());
        this.sled = sledEntity;
        this.f_119578_ = true;
        this.f_119579_ = 0;
        this.f_119573_ = 0.0f;
        this.isSnow = isSnow;
    }

    public boolean m_7767_() {
        return !this.sled.m_20067_();
    }

    public boolean m_7784_() {
        return true;
    }

    public void m_7788_() {
        ++this.time;
        if (!this.sled.m_213877_()) {
            this.f_119575_ = (float)this.sled.m_20185_();
            this.f_119576_ = (float)this.sled.m_20186_();
            this.f_119577_ = (float)this.sled.m_20189_();
            float f = (float)this.sled.m_20184_().m_82556_();
            if (f > 0.05f) {
                ++this.fastTime;
            } else {
                this.fastTime = 0;
                this.f_119573_ = 0.0f;
                return;
            }
            this.f_119573_ = (double)f >= 1.0E-7 ? Mth.m_14036_((float)(f / 25.0f), (float)0.0f, (float)1.1f) : 0.0f;
            if (this.time < 20) {
                this.f_119573_ *= (float)(this.fastTime - 20) / 20.0f;
            }
            if (this.isSnow) {
                if (!this.sled.getCurrentStatus().onSnow()) {
                    this.f_119573_ = 0.0f;
                    this.ticksOnSnow = 0;
                } else {
                    ++this.ticksOnSnow;
                    if (this.ticksOnSnow < 5) {
                        this.f_119573_ *= (float)(this.ticksOnSnow - 5) / 5.0f;
                    }
                    this.f_119573_ = Math.min(0.8f, this.f_119573_);
                }
            }
            float f1 = 0.8f;
            this.f_119574_ = this.f_119573_ > 0.8f ? 1.0f + (this.f_119573_ - 0.8f) : 1.0f;
            this.f_119573_ = (float)((double)this.f_119573_ * ClientConfigs.SLED_SOUND_AMPLIFIER.get());
        } else {
            this.m_119609_();
        }
    }

    public static void playAt(SledEntity sledEntity) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SledSoundInstance(sledEntity, false));
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SledSoundInstance(sledEntity, true));
    }
}

