/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.client.QuiltModel;
import net.mehvahdjukaar.snowyspirit.client.SledModel;
import net.mehvahdjukaar.snowyspirit.common.entity.SledEntity;
import net.mehvahdjukaar.snowyspirit.reg.ClientRegistry;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class SledEntityRenderer
extends EntityRenderer<SledEntity> {
    private final Map<WoodType, ResourceLocation> textures;
    private final Map<DyeColor, ResourceLocation> quiltTextures;
    private final SledModel<SledEntity> model;
    private final SledModel<SledEntity> modelBamboo;
    private final QuiltModel<SledEntity> quiltModel;

    public SledEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.8f;
        this.model = new SledModel(context.m_174023_(ClientRegistry.SLED_MODEL));
        this.modelBamboo = new SledModel(context.m_174023_(ClientRegistry.SLED_MODEL_BAMBOO));
        this.quiltModel = new QuiltModel(context.m_174023_(ClientRegistry.QUILT_MODEL));
        this.textures = (Map)WoodTypeRegistry.getTypes().stream().collect(ImmutableMap.toImmutableMap(e -> e, t -> SnowySpirit.res("textures/entity/sled/" + t.getTexturePath() + ".png")));
        this.quiltTextures = (Map)Stream.of(DyeColor.values()).collect(ImmutableMap.toImmutableMap(e -> e, t -> new ResourceLocation("snowyspirit:textures/entity/sled/quilt/" + t.m_41065_() + ".png")));
    }

    public void render(SledEntity sled, float yRot, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        double dy = Mth.m_14139_((double)partialTicks, (double)sled.prevAdditionalY, (double)sled.cachedAdditionalY);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.375 + dy, 0.0);
        float xRot = sled.m_5686_(partialTicks);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - yRot));
        poseStack.m_252781_(Axis.f_252495_.m_252977_(xRot));
        float hurtTme = (float)sled.getHurtTime() - partialTicks;
        float damage = sled.getDamage() - partialTicks;
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        float zRot = 0.0f;
        if (hurtTme > 0.0f) {
            zRot = Mth.m_14031_((float)hurtTme) * hurtTme * damage / 10.0f * (float)sled.getHurtDir();
            poseStack.m_252781_(Axis.f_252403_.m_252977_(zRot));
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.125, 0.4);
        poseStack.m_85841_(0.75f, 0.75f, 0.75f);
        poseStack.m_85837_(-0.5, 0.0, -0.5);
        poseStack.m_85849_();
        ResourceLocation resourcelocation = this.getTextureLocation(sled);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        VertexConsumer vertexconsumer = bufferSource.m_6299_(this.model.m_103119_(resourcelocation));
        SledModel<SledEntity> mod = resourcelocation.m_135815_().equals("textures/entity/sled/bamboo.png") ? this.modelBamboo : this.model;
        mod.m_7695_(poseStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        DyeColor color = sled.getSeatType();
        if (color != null) {
            vertexconsumer = bufferSource.m_6299_(this.model.m_103119_(this.quiltTextures.get(color)));
            this.quiltModel.m_7695_(poseStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85849_();
        this.renderLeash(sled, partialTicks, poseStack, bufferSource, (float)Math.toRadians(90.0f + yRot), (float)Math.toRadians(xRot), (float)Math.toRadians(zRot), dy);
        super.m_7392_((Entity)sled, yRot, partialTicks, poseStack, bufferSource, light);
        if (this.f_114476_.m_114377_()) {
            this.renderDebugHitbox(poseStack, bufferSource.m_6299_(RenderType.m_110504_()), sled, partialTicks);
        }
    }

    public ResourceLocation getTextureLocation(SledEntity sled) {
        return this.textures.get(sled.getWoodType());
    }

    private void renderDebugHitbox(PoseStack pMatrixStack, VertexConsumer pBuffer, SledEntity pEntity, float pPartialTicks) {
        AABB aabb = pEntity.m_20191_().m_82383_(SledEntityRenderer.lerpV(pPartialTicks, pEntity.prevProjectedPos, pEntity.projectedPos)).m_82386_(-pEntity.m_20185_(), -pEntity.m_20186_(), -pEntity.m_20189_());
        LevelRenderer.m_109646_((PoseStack)pMatrixStack, (VertexConsumer)pBuffer, (AABB)aabb, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (pEntity.hasPuller()) {
            aabb = pEntity.pullerAABB.m_82386_(-pEntity.m_20185_(), -pEntity.m_20186_(), -pEntity.m_20189_());
            LevelRenderer.m_109646_((PoseStack)pMatrixStack, (VertexConsumer)pBuffer, (AABB)aabb, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        }
        Vec3 movement = SledEntityRenderer.lerpV(pPartialTicks, pEntity.prevDeltaMovement, pEntity.m_20184_());
        Matrix4f matrix4f = pMatrixStack.m_85850_().m_252922_();
        Matrix3f matrix3f = pMatrixStack.m_85850_().m_252943_();
        float mult = 6.0f;
        float eye = pEntity.m_20192_() + 1.0f + pEntity.cachedAdditionalY;
        pBuffer.m_252986_(matrix4f, 0.0f, eye, 0.0f).m_6122_(0, 255, 0, 255).m_252939_(matrix3f, (float)movement.f_82479_, (float)movement.f_82480_, (float)movement.f_82481_).m_5752_();
        pBuffer.m_252986_(matrix4f, (float)(movement.f_82479_ * (double)mult), (float)((double)eye + movement.f_82480_ * (double)mult), (float)(movement.f_82481_ * (double)mult)).m_6122_(0, 255, 0, 255).m_252939_(matrix3f, (float)movement.f_82479_, (float)movement.f_82480_, (float)movement.f_82481_).m_5752_();
        pBuffer.m_252986_(matrix4f, 0.0f, eye + 0.25f, 0.0f).m_6122_(255, 0, 255, 255).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        pBuffer.m_252986_(matrix4f, 0.0f, (float)((double)(eye + 0.25f) + pEntity.misalignedFrictionFactor), 0.0f).m_6122_(255, 0, 255, 255).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        if (pEntity.boost) {
            movement = movement.m_82541_().m_82490_(-1.0);
            pBuffer.m_252986_(matrix4f, 0.0f, eye, 0.0f).m_6122_(255, 255, 0, 255).m_252939_(matrix3f, (float)movement.f_82479_, (float)movement.f_82480_, (float)movement.f_82481_).m_5752_();
            pBuffer.m_252986_(matrix4f, (float)movement.f_82479_, (float)((double)eye + movement.f_82480_), (float)movement.f_82481_).m_6122_(255, 255, 0, 255).m_252939_(matrix3f, (float)movement.f_82479_, (float)movement.f_82480_, (float)movement.f_82481_).m_5752_();
        }
    }

    public static Vec3 lerpV(float delta, Vec3 start, Vec3 end) {
        return new Vec3(Mth.m_14139_((double)delta, (double)start.f_82479_, (double)end.f_82479_), Mth.m_14139_((double)delta, (double)start.f_82480_, (double)end.f_82480_), Mth.m_14139_((double)delta, (double)start.f_82481_, (double)end.f_82481_));
    }

    private void renderLeash(SledEntity sled, float pPartialTicks, PoseStack poseStack, MultiBufferSource pBuffer, float yRot, float xRot, float zRot, double addY) {
        Animal wolf = sled.getSledPuller();
        if (wolf != null) {
            boolean bear = Utils.getID((EntityType)wolf.m_6095_()).m_135815_().equals("grizzly_bear");
            Vec3 wolfPos = wolf.m_7398_(pPartialTicks).m_82520_(0.0, wolf.m_6162_() ? 0.1 : 0.25, 0.0);
            float bbw = wolf.m_20205_() / (2.875f + (bear ? 1.5f : 0.0f));
            Vec3 sledOffset = new Vec3((double)0.4125f, 0.0, (double)0.95f);
            Vec3 ropeOffset = new Vec3((double)bbw, 0.0, 0.0);
            float cos = Mth.m_14089_((float)yRot);
            float sin = Mth.m_14031_((float)yRot);
            float pCos = Mth.m_14089_((float)xRot);
            float pSin = Mth.m_14031_((float)xRot);
            float wSin = Mth.m_14031_((float)zRot);
            double sledX = Mth.m_14139_((double)pPartialTicks, (double)sled.f_19854_, (double)sled.m_20185_());
            double sledY = Mth.m_14139_((double)pPartialTicks, (double)sled.f_19855_, (double)sled.m_20186_());
            double sledZ = Mth.m_14139_((double)pPartialTicks, (double)sled.f_19856_, (double)sled.m_20189_());
            BlockPos sledEyePos = BlockPos.m_274446_((Position)sled.m_20299_(pPartialTicks));
            BlockPos wolfEyePos = BlockPos.m_274446_((Position)wolf.m_20299_(pPartialTicks));
            for (int rope = -1; rope <= 1; rope += 2) {
                int index;
                VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_110475_());
                poseStack.m_85836_();
                double wolfOffsetX = (double)cos * ropeOffset.f_82481_ + (double)sin * ropeOffset.f_82479_ * (double)rope;
                double wolfOffsetZ = (double)sin * ropeOffset.f_82481_ - (double)cos * ropeOffset.f_82479_ * (double)rope;
                double offsetX = ((double)cos * sledOffset.f_82481_ + (double)sin * sledOffset.f_82479_ * (double)rope) * (double)pCos;
                double offsetZ = ((double)sin * sledOffset.f_82481_ - (double)cos * sledOffset.f_82479_ * (double)rope) * (double)pCos;
                double offsetY = (double)(-pSin) * sledOffset.m_82553_() + 0.25 + addY - sledOffset.f_82479_ * (double)wSin * (double)rope;
                double pX = sledX + offsetX;
                double pY = sledY + offsetY;
                double pZ = sledZ + offsetZ;
                poseStack.m_85837_(offsetX, offsetY, offsetZ);
                float deltaX = (float)(wolfPos.f_82479_ + wolfOffsetX - pX);
                float deltaY = (float)(wolfPos.f_82480_ - pY);
                float deltaZ = (float)(wolfPos.f_82481_ + wolfOffsetZ - pZ);
                float width = 0.025f;
                Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                float f4 = Mth.m_264536_((float)(deltaX * deltaX + deltaZ * deltaZ)) * width / 2.0f;
                float mathZ = deltaZ * f4;
                float mathX = deltaX * f4;
                int blockLight0 = this.m_6086_(sled, sledEyePos);
                Level level = wolf.m_9236_();
                int blockLight1 = wolf.m_6060_() ? 15 : level.m_45517_(LightLayer.BLOCK, wolfEyePos);
                int skyLight0 = level.m_45517_(LightLayer.SKY, sledEyePos);
                int skyLight1 = level.m_45517_(LightLayer.SKY, wolfEyePos);
                int maxSegments = 12;
                for (index = 0; index <= maxSegments; ++index) {
                    SledEntityRenderer.addVertexPair(vertexconsumer, matrix4f, deltaX, deltaY, deltaZ, blockLight0, blockLight1, skyLight0, skyLight1, 0.025f, 0.025f, mathZ, mathX, index, false, maxSegments);
                }
                for (index = maxSegments; index >= 0; --index) {
                    SledEntityRenderer.addVertexPair(vertexconsumer, matrix4f, deltaX, deltaY, deltaZ, blockLight0, blockLight1, skyLight0, skyLight1, 0.025f, 0.0f, mathZ, mathX, index, true, maxSegments);
                }
                poseStack.m_85849_();
                if (!(pBuffer instanceof MultiBufferSource.BufferSource)) continue;
                MultiBufferSource.BufferSource bu = (MultiBufferSource.BufferSource)pBuffer;
                bu.m_109911_();
            }
        }
    }

    private static void addVertexPair(VertexConsumer vertexConsumer, Matrix4f matrix4f, float startX, float startY, float startZ, int blockLight0, int blockLight1, int skyLight0, int skyLight1, float y0, float y1, float dx, float dz, int index, boolean flippedColors, int maxSegments) {
        float segment = (float)index / (float)maxSegments;
        int i = (int)Mth.m_14179_((float)segment, (float)blockLight0, (float)blockLight1);
        int j = (int)Mth.m_14179_((float)segment, (float)skyLight0, (float)skyLight1);
        int light = LightTexture.m_109885_((int)i, (int)j);
        float darker = index % 2 == (flippedColors ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * darker;
        float green = 0.4f * darker;
        float blue = 0.3f * darker;
        float sx = startX * segment;
        float sy = startY > 0.0f ? startY * segment * segment : startY - startY * (1.0f - segment) * (1.0f - segment);
        float sz = startZ * segment;
        vertexConsumer.m_252986_(matrix4f, sx - dx, sy + y1, sz + dz).m_85950_(red, green, blue, 1.0f).m_85969_(light).m_5752_();
        vertexConsumer.m_252986_(matrix4f, sx + dx, sy + y0 - y1, sz - dz).m_85950_(red, green, blue, 1.0f).m_85969_(light).m_5752_();
    }
}

