/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mehvahdjukaar.moonlight.api.client.util.ParticleUtil;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.snowyspirit.configs.ClientConfigs;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class GlowLightParticle
extends TextureSheetParticle {
    private final float scale;
    private float oldQuadSize;
    private final float deltaRot;
    protected final SpriteSet sprites;
    private static final ParticleRenderType RENDER_TYPE = PlatHelper.getPlatform().isForge() ? ParticleUtil.ADDITIVE_TRANSLUCENCY_RENDER_TYPE : ParticleRenderType.f_107431_;

    private GlowLightParticle(ClientLevel arg, double d, double e, double f, SpriteSet sprites) {
        super(arg, d, e, f);
        this.sprites = sprites;
        this.f_107226_ = 0.0f;
        this.f_107225_ = 19 + this.f_107223_.m_188503_(12);
        this.f_107219_ = false;
        this.f_107230_ = 0.0f;
        this.f_107663_ = 0.0f;
        this.f_107222_ = 0.2f;
        this.f_107221_ = 0.2f;
        this.deltaRot = MthUtils.nextWeighted((RandomSource)this.f_107223_, (float)0.03f, (float)500.0f);
        this.scale = 0.05f + MthUtils.nextWeighted((RandomSource)this.f_107223_, (float)0.15f, (float)1.0f);
        this.f_107231_ = (float)(Math.PI * (double)this.f_107223_.m_188501_());
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Vector3f[] quadPos;
        Quaternionf quaternion;
        this.m_108337_(this.sprites.m_5819_(0, 3));
        Vec3 vec3 = renderInfo.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float z = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        int lightColor = this.m_6355_(partialTicks);
        if (this.f_107231_ == 0.0f) {
            quaternion = renderInfo.m_253121_();
        } else {
            quaternion = new Quaternionf((Quaternionfc)renderInfo.m_253121_());
            float i = Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_);
            quaternion.mul((Quaternionfc)Axis.f_252403_.m_252961_(i));
        }
        for (Vector3f v : quadPos = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)}) {
            v.rotate((Quaternionfc)quaternion);
        }
        float size = this.m_5902_(partialTicks);
        int mode = ClientConfigs.PARTICLE_MODE.get() - 1;
        if (mode == 0) {
            GlowLightParticle.renderQuad(this.f_108321_, buffer, x, y, z, lightColor, quadPos, size, this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * 0.4f);
            this.m_108337_(this.sprites.m_5819_(2, 3));
            GlowLightParticle.renderQuad(this.f_108321_, buffer, x, y, z, lightColor, quadPos, size, 0.5f + this.f_107227_ / 2.0f, 0.5f + this.f_107228_ / 2.0f, 0.5f + this.f_107229_ / 2.0f, this.f_107230_ * 0.6f);
        } else if (mode == 1) {
            GlowLightParticle.renderQuad(this.f_108321_, buffer, x, y, z, lightColor, quadPos, size * 1.5f, this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * 0.3f);
            GlowLightParticle.renderQuad(this.f_108321_, buffer, x, y, z, lightColor, quadPos, size, 0.5f + this.f_107227_ / 2.0f, 0.5f + this.f_107228_ / 2.0f, 0.5f + this.f_107229_ / 2.0f, this.f_107230_ * 0.4f);
            this.m_108337_(this.sprites.m_5819_(2, 3));
            GlowLightParticle.renderQuad(this.f_108321_, buffer, x, y, z, lightColor, quadPos, size, 1.0f, 1.0f, 1.0f, this.f_107230_ * 0.3f);
        } else if (mode == 2) {
            GlowLightParticle.renderQuad(this.f_108321_, buffer, x, y, z, lightColor, quadPos, size, this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * 0.8f);
            this.m_108337_(this.sprites.m_5819_(2, 3));
            GlowLightParticle.renderQuad(this.f_108321_, buffer, x, y, z, lightColor, quadPos, size, 1.0f, 1.0f, 1.0f, this.f_107230_ * 0.3f);
        }
        this.m_108337_(this.sprites.m_5819_(3, 3));
        GlowLightParticle.renderQuad(this.f_108321_, buffer, x, y, z, lightColor, quadPos, size, 1.0f, 1.0f, 1.0f, this.f_107230_ * 0.5f);
    }

    private static void renderQuad(TextureAtlasSprite sprite, VertexConsumer buffer, float x, float y, float z, int lightColor, Vector3f[] quadPos, float size, float rCol, float gCol, float bCol, float alpha) {
        float u0 = sprite.m_118409_();
        float u1 = sprite.m_118410_();
        float v0 = sprite.m_118411_();
        float v1 = sprite.m_118412_();
        u1 = u0 + (u1 - u0) * 7.0f / 8.0f;
        v1 = v0 + (v1 - v0) * 7.0f / 8.0f;
        buffer.m_5483_((double)(x + quadPos[0].x() * size), (double)(y + quadPos[0].y() * size), (double)(z + quadPos[0].z() * size)).m_7421_(u1, v1).m_85950_(rCol, gCol, bCol, alpha).m_85969_(lightColor).m_5752_();
        buffer.m_5483_((double)(x + quadPos[1].x() * size), (double)(y + quadPos[1].y() * size), (double)(z + quadPos[1].z() * size)).m_7421_(u1, v0).m_85950_(rCol, gCol, bCol, alpha).m_85969_(lightColor).m_5752_();
        buffer.m_5483_((double)(x + quadPos[2].x() * size), (double)(y + quadPos[2].y() * size), (double)(z + quadPos[2].z() * size)).m_7421_(u0, v0).m_85950_(rCol, gCol, bCol, alpha).m_85969_(lightColor).m_5752_();
        buffer.m_5483_((double)(x + quadPos[3].x() * size), (double)(y + quadPos[3].y() * size), (double)(z + quadPos[3].z() * size)).m_7421_(u0, v1).m_85950_(rCol, gCol, bCol, alpha).m_85969_(lightColor).m_5752_();
    }

    public ParticleRenderType m_7556_() {
        return RENDER_TYPE;
    }

    public float m_5902_(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.oldQuadSize, (float)this.f_107663_);
    }

    public void m_5989_() {
        super.m_5989_();
        float sin = Mth.m_14031_((float)((float)(Math.PI * (double)this.f_107224_ / (double)this.f_107225_)));
        this.f_107230_ = (float)Math.pow(sin, 0.2);
        this.oldQuadSize = this.f_107663_;
        this.f_107663_ = (float)((double)this.scale * Math.pow(sin, 0.4));
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += this.deltaRot;
    }

    protected int m_6355_(float partialTick) {
        int i = super.m_6355_(partialTick);
        int k = i >> 16 & 0xFF;
        int a = (int)(255.0f * Mth.m_14031_((float)((float)(Math.PI * (double)this.f_107224_ / (double)this.f_107225_))));
        return a | k << 16;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double reg, double green, double blue) {
            GlowLightParticle p = new GlowLightParticle(level, x, y, z, this.sprites);
            p.m_107253_((float)reg, (float)green, (float)blue);
            return p;
        }
    }
}

