/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.skillsexpnotifier.client;

import com.github.spacemex.skillsexpnotifier.Config;
import com.github.spacemex.skillsexpnotifier.Skillsexpnotifier;
import com.github.spacemex.skillsexpnotifier.client.ToastConfig;
import com.github.spacemex.skillsexpnotifier.client.XpToast;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class CustomToastComponent {
    private final Minecraft minecraft;
    private final List<CustomToastInstance<?>> visible = new ArrayList();
    private final BitSet occupiedSlots = new BitSet();
    private final Deque<Toast> queued = Queues.newArrayDeque();

    public CustomToastComponent(Minecraft minecraft) {
        this.minecraft = Objects.requireNonNull(minecraft);
    }

    private boolean useToastControl() {
        return (Boolean)Config.TOAST_CONTROL.get() != false && ToastConfig.isToastControlInstalled();
    }

    public void addToast(Toast toast) {
        if (((Boolean)Config.DISABLE_TOASTS.get()).booleanValue()) {
            return;
        }
        if (ForgeHooksClient.onToastAdd((Toast)toast)) {
            return;
        }
        XpToast existingVisible = this.getToast(XpToast.class, toast.m_7283_());
        if (existingVisible != null && toast instanceof XpToast) {
            XpToast incoming = (XpToast)toast;
            existingVisible.addGained(incoming.getGained());
            Skillsexpnotifier.LOGGER.debug("Merged Visible toast {} and {}", (Object)existingVisible, (Object)toast);
            return;
        }
        for (Toast queuedToast : this.queued) {
            if (!(queuedToast instanceof XpToast)) continue;
            XpToast queuedXp = (XpToast)queuedToast;
            if (queuedToast.getClass() != toast.getClass() || !Objects.equals(queuedToast.m_7283_(), toast.m_7283_())) continue;
            queuedXp.addGained(((XpToast)toast).getGained());
            Skillsexpnotifier.LOGGER.debug("Merged toasts {} and {}", (Object)queuedToast, (Object)toast);
            return;
        }
        this.queued.add(toast);
        Skillsexpnotifier.LOGGER.debug("Queued toast {}", (Object)toast);
    }

    public void render(GuiGraphics graphics) {
        if (this.minecraft.f_91066_.f_92062_) {
            return;
        }
        int screenWidth = graphics.m_280182_();
        Iterator<CustomToastInstance<?>> it = this.visible.iterator();
        while (it.hasNext()) {
            CustomToastInstance<?> instance = it.next();
            if (!instance.render(screenWidth, graphics)) continue;
            this.occupiedSlots.clear(instance.index, instance.index + instance.slotCount);
            it.remove();
        }
        if (!this.queued.isEmpty() && this.freeSlots() > 0) {
            Iterator<Toast> qi = this.queued.iterator();
            while (qi.hasNext() && this.freeSlots() > 0) {
                Toast toast = qi.next();
                int slots = toast.m_243110_();
                int idx = this.findFreeIndex(slots);
                if (idx == -1) continue;
                this.visible.add(new CustomToastInstance(this, toast, idx, slots));
                this.occupiedSlots.set(idx, idx + slots);
                qi.remove();
            }
        }
    }

    private int freeSlots() {
        return this.getSlotCount() - this.occupiedSlots.cardinality();
    }

    private int findFreeIndex(int slotCount) {
        if (this.freeSlots() < slotCount) {
            return -1;
        }
        int count = 0;
        for (int i = 0; i < this.getSlotCount(); ++i) {
            if (this.occupiedSlots.get(i)) {
                count = 0;
                continue;
            }
            if (++count != slotCount) continue;
            return i + 1 - slotCount;
        }
        return -1;
    }

    public <T extends Toast> T getToast(Class<? extends T> pToastClass, Object token) {
        for (CustomToastInstance<?> inst : this.visible) {
            Object t = inst.toast;
            if (!pToastClass.isAssignableFrom(t.getClass()) || !t.m_7283_().equals(token)) continue;
            return t;
        }
        for (Toast t : this.queued) {
            if (!pToastClass.isAssignableFrom(t.getClass()) || !t.m_7283_().equals(token)) continue;
            return (T)t;
        }
        return null;
    }

    private int getBaseX() {
        return (Integer)Config.X_OFFSET.get();
    }

    private int getBaseY() {
        return (Integer)Config.Y_OFFSET.get();
    }

    private int getSlotCount() {
        if (this.useToastControl()) {
            return Math.max(1, ToastConfig.toastCount());
        }
        return Math.max(1, (Integer)Config.MAX_TOASTS.get());
    }

    private long getAnimationTime() {
        if (this.useToastControl()) {
            return ToastConfig.forceTime();
        }
        return (Long)Config.ANIMATION_TIME.get() <= 0L ? 6000L : (Long)Config.ANIMATION_TIME.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    private class CustomToastInstance<T extends Toast> {
        private final T toast;
        private final int index;
        private final int slotCount;
        private long animationTime = -1L;
        private long visibleTime = -1L;
        private Toast.Visibility visibility = Toast.Visibility.SHOW;
        final /* synthetic */ CustomToastComponent this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        CustomToastInstance(T toast, int index, int slotCount) {
            this.this$0 = (CustomToastComponent)n;
            this.toast = toast;
            this.index = index;
            this.slotCount = slotCount;
            if (toast instanceof XpToast) {
                XpToast xpToast = (XpToast)toast;
                xpToast.addGained(0);
            }
        }

        public boolean render(int screenWidth, GuiGraphics graphics) {
            XpToast xp;
            T t;
            float y;
            float x;
            float anchorX;
            long now = Util.m_137550_();
            if (this.animationTime < 0L) {
                this.animationTime = now;
                if (!((Boolean)Config.DISABLE_TOAST_SOUNDS.get()).booleanValue()) {
                    SoundEvent inSound;
                    String dimKey = this.this$0.minecraft.f_91073_.m_46472_().m_135782_().toString();
                    if (dimKey.isEmpty()) {
                        dimKey = "minecraft:overworld";
                    }
                    if ((inSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)Config.getSoundInForDimension(dimKey)))) != null) {
                        this.this$0.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)inSound, (float)1.0f, (float)1.0f));
                    } else {
                        Skillsexpnotifier.LOGGER.warn("Sound For Toast In Not Found: {} Using Default Sound For Toast In", (Object)Config.getSoundOutForDimension(dimKey));
                        this.visibility.m_94909_(this.this$0.minecraft.m_91106_());
                    }
                }
            }
            if (this.visibility == Toast.Visibility.SHOW && now - this.animationTime <= this.this$0.getAnimationTime()) {
                this.visibleTime = now;
            }
            float t2 = (float)(now - this.animationTime) / (float)this.this$0.getAnimationTime();
            t2 = Math.min(1.0f, Math.max(0.0f, t2));
            float ease = t2 * t2;
            if (this.visibility == Toast.Visibility.HIDE) {
                ease = 1.0f - ease;
            }
            graphics.m_280168_().m_85836_();
            String anchor = ((String)Config.ANCHOR_POSITION.get()).toLowerCase();
            int toastW = this.toast.m_7828_();
            int toastH = this.toast.m_94899_();
            int screenH = graphics.m_280206_();
            float anchorY = switch (anchor) {
                case "top-left" -> {
                    anchorX = 0.0f;
                    yield 0.0f;
                }
                case "top-center" -> {
                    anchorX = (float)(screenWidth - toastW) / 2.0f;
                    yield 0.0f;
                }
                case "top-right" -> {
                    anchorX = screenWidth - toastW;
                    yield 0.0f;
                }
                case "middle-left" -> {
                    anchorX = 0.0f;
                    yield (float)(screenH - toastH) / 2.0f;
                }
                case "middle-center", "center" -> {
                    anchorX = (float)(screenWidth - toastW) / 2.0f;
                    yield (float)(screenH - toastH) / 2.0f;
                }
                case "middle-right" -> {
                    anchorX = screenWidth - toastW;
                    yield (float)(screenH - toastH) / 2.0f;
                }
                case "bottom-left" -> {
                    anchorX = 0.0f;
                    yield screenH - toastH;
                }
                case "bottom-center" -> {
                    anchorX = (float)(screenWidth - toastW) / 2.0f;
                    yield screenH - toastH;
                }
                case "bottom-right" -> {
                    anchorX = screenWidth - toastW;
                    yield screenH - toastH;
                }
                default -> {
                    anchorX = screenWidth - toastW;
                    yield screenH - toastH;
                }
            };
            anchorX += (float)this.this$0.getBaseX();
            anchorY += (float)this.this$0.getBaseY();
            String dir = ((String)Config.ANIMATION_DIRECTION.get()).toLowerCase();
            boolean isLeft = dir.equals("left");
            boolean isRight = dir.equals("right");
            boolean isTop = dir.equals("top");
            boolean isDown = dir.equals("down");
            boolean noSlide = (Boolean)Config.NO_SLIDE.get();
            boolean slideH = !noSlide && (isLeft || isRight);
            boolean slideV = !noSlide && (isTop || isDown);
            boolean slideFromLeft = isLeft && !isRight;
            boolean stackTopDown = isTop && !isDown;
            float slideX = (1.0f - ease) * (float)toastW;
            float slideY = (1.0f - ease) * (float)toastH;
            if (slideH) {
                x = slideFromLeft ? anchorX - slideX : anchorX + slideX;
                y = anchorY + (float)(stackTopDown ? this.index * toastH : -this.index * toastH);
            } else if (slideV) {
                x = anchorX + (float)(stackTopDown ? this.index * toastW : -this.index * toastW);
                y = isTop ? anchorY - slideY : anchorY + slideY;
            } else {
                x = anchorX;
                y = anchorY + (float)(this.index * toastH);
            }
            graphics.m_280168_().m_252880_(x, y, 800.0f);
            Toast.Visibility newVis = this.toast.m_7172_(graphics, null, now - this.visibleTime);
            graphics.m_280168_().m_85849_();
            if (newVis != this.visibility) {
                this.animationTime = now - (long)((1.0f - ease) * (float)this.this$0.getAnimationTime());
                this.visibility = newVis;
                if (!((Boolean)Config.DISABLE_TOAST_SOUNDS.get()).booleanValue()) {
                    SoundEvent outSound;
                    String dimKey = this.this$0.minecraft.f_91073_.m_46472_().m_135782_().toString();
                    if (dimKey.isEmpty()) {
                        dimKey = "minecraft:overworld";
                    }
                    if ((outSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)Config.getSoundOutForDimension(dimKey)))) != null) {
                        this.this$0.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)outSound, (float)1.0f, (float)1.0f));
                    } else {
                        Skillsexpnotifier.LOGGER.warn("Sound For Toast Out Not Found: {} Using Default Sound For Toast Out", (Object)Config.getSoundOutForDimension(dimKey));
                        this.visibility.m_94909_(this.this$0.minecraft.m_91106_());
                    }
                }
            }
            boolean finished = (t = this.toast) instanceof XpToast ? now - (xp = (XpToast)t).getLastUpdateTime() > (Long)Config.STACK_XP_TIMER.get() : this.visibility == Toast.Visibility.HIDE && now - this.animationTime > this.this$0.getAnimationTime();
            return finished;
        }
    }
}

