/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.skillsexpnotifier.client;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.github.spacemex.skillsexpnotifier.Config;
import com.github.spacemex.skillsexpnotifier.Skillsexpnotifier;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(modid="skillsexpnotifier", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ConfigWatcher {
    private static final Path CONFIG = FMLPaths.CONFIGDIR.get().resolve("SkillExpNotifier/config.toml");
    private static long lastModified = -1L;

    public static void initWatcher() {
        try {
            lastModified = Files.getLastModifiedTime(CONFIG, new LinkOption[0]).toMillis();
            Skillsexpnotifier.LOGGER.info("[File Watcher] Config loaded, last modified: {}", (Object)lastModified);
        }
        catch (IOException e) {
            Skillsexpnotifier.LOGGER.error("[File Watcher]Could not read Config timeStamp", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (!((Boolean)Config.ENABLE_FILE_WATCHER.get()).booleanValue()) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        try {
            long lm = Files.getLastModifiedTime(CONFIG, new LinkOption[0]).toMillis();
            if (lm > lastModified) {
                lastModified = lm;
                ConfigWatcher.reloadConfig();
                Skillsexpnotifier.LOGGER.info("[File Watcher] Config changed, reloading...");
            }
        }
        catch (IOException e) {
            Skillsexpnotifier.LOGGER.error("Could not read Config timeStamp", (Throwable)e);
        }
    }

    private static void reloadConfig() {
        if (!((Boolean)Config.ENABLE_FILE_WATCHER.get()).booleanValue()) {
            return;
        }
        CommentedFileConfig cf = (CommentedFileConfig)CommentedFileConfig.builder((Path)CONFIG).sync().autosave().writingMode(WritingMode.REPLACE).build();
        cf.load();
        Config.SPEC.setConfig((CommentedConfig)cf);
        Skillsexpnotifier.LOGGER.info("[File Watcher] Config reloaded.");
    }
}

