/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.selectivebounds;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.conczin.selectivebounds.config.Config;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class TagManager {
    private final Config config;
    private final Map<String, Set<Item>> tagToItemsCache = new HashMap<String, Set<Item>>();
    private final Map<String, Set<Block>> tagToBlocksCache = new HashMap<String, Set<Block>>();
    private final Map<String, FilteredType> cache = new HashMap<String, FilteredType>();

    public TagManager(Config config) {
        this.config = config;
    }

    public Set<Item> getItemsFromTag(String tag) {
        if (this.tagToItemsCache.containsKey(tag)) {
            return this.tagToItemsCache.get(tag);
        }
        ResourceLocation location = new ResourceLocation(tag.startsWith("#") ? tag.substring(1) : tag);
        TagKey tagKey = TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)location);
        HashSet<Item> items = new HashSet<Item>();
        for (Holder holder : BuiltInRegistries.f_257033_.m_206058_(tagKey)) {
            items.add((Item)holder.m_203334_());
        }
        this.tagToItemsCache.put(tag, items);
        return items;
    }

    public Set<Block> getBlocksFromTag(String tag) {
        if (this.tagToBlocksCache.containsKey(tag)) {
            return this.tagToBlocksCache.get(tag);
        }
        ResourceLocation location = new ResourceLocation(tag.startsWith("#") ? tag.substring(1) : tag);
        TagKey tagKey = TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_256975_.m_123023_(), (ResourceLocation)location);
        HashSet<Block> blocks = new HashSet<Block>();
        for (Holder holder : BuiltInRegistries.f_256975_.m_206058_(tagKey)) {
            blocks.add((Block)holder.m_203334_());
        }
        this.tagToBlocksCache.put(tag, blocks);
        return blocks;
    }

    public FilteredType get(Item item, Block block) {
        ResourceLocation itemKey = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        ResourceLocation blockKey = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        String key = String.valueOf(itemKey) + "$" + String.valueOf(blockKey);
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        FilteredType type = FilteredType.IGNORE;
        for (Config.OutlineOverride override : this.config.overrides) {
            if (!override.item.equals("all") && !override.item.equals(itemKey.toString()) && !this.getItemsFromTag(override.item).contains(item) || !override.block.equals("all") && !override.block.equals(blockKey.toString()) && !this.getBlocksFromTag(override.block).contains(block)) continue;
            type = override.show ? FilteredType.WHITELIST : FilteredType.BLACKLIST;
            break;
        }
        this.cache.put(key, type);
        return type;
    }

    public static enum FilteredType {
        BLACKLIST,
        WHITELIST,
        IGNORE;

    }
}

