/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.impl.seasons;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.config.SeasonHudServer;
import club.iananderson.seasonhud.impl.seasons.CommonSeasonHelper;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import io.wispforest.accessories.api.AccessoriesCapability;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import top.theillusivec4.curios.api.CuriosApi;

public class Calendar {
    private Calendar() {
    }

    public static boolean findCuriosCalendar(Player player, Item item) {
        Optional accessoriesInventory;
        Minecraft mc = Minecraft.m_91087_();
        boolean curioEquipped = false;
        if (mc.f_91073_ == null || mc.f_91074_ == null || item == null) {
            return false;
        }
        if (Common.curiosLoaded() && !Common.accessoriesLoaded()) {
            List curiosInventory = CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, item);
            boolean bl = curioEquipped = !curiosInventory.isEmpty();
        }
        if (Common.trinketsLoaded() && !Common.accessoriesLoaded()) {
            Optional trinketInventory = TrinketsApi.getTrinketComponent((LivingEntity)player);
            if (trinketInventory.isPresent()) {
                curioEquipped = ((TrinketComponent)trinketInventory.get()).isEquipped(item);
            }
        } else if (Common.accessoriesLoaded() && (accessoriesInventory = AccessoriesCapability.getOptionally((LivingEntity)player)).isPresent()) {
            curioEquipped = !((AccessoriesCapability)accessoriesInventory.get()).getEquipped(item).isEmpty();
        }
        return curioEquipped;
    }

    private static boolean findCalendar(Player player, Item item) {
        boolean invCalendarFound = player.m_150109_().m_36063_(item.m_7968_());
        boolean curiosCalendarFound = Calendar.findCuriosCalendar(player, item);
        return invCalendarFound | curiosCalendarFound;
    }

    private static boolean calendarFound() {
        Minecraft mc = Minecraft.m_91087_();
        Item calendar = CommonSeasonHelper.commonSeasons.CALENDAR();
        if (!Common.hasCalendarLoaded()) {
            return true;
        }
        if (mc.f_91073_ == null || mc.f_91074_ == null || calendar == null) {
            return false;
        }
        return Calendar.findCalendar((Player)mc.f_91074_, calendar);
    }

    public static boolean validNeedCalendar() {
        return SeasonHudServer.getNeedCalendar() && Calendar.calendarFound() || !SeasonHudServer.getNeedCalendar();
    }

    public static boolean validDetailedMode() {
        return SeasonHudServer.getCalendarDetailMode() && Calendar.calendarFound() || !SeasonHudServer.getCalendarDetailMode();
    }
}

