/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.living.undeadminer;

import com.github.teamfusion.rottencreatures.common.registries.RCBlocks;
import com.github.teamfusion.rottencreatures.core.RottenCreatures;
import com.github.teamfusion.rottencreatures.core.data.loot.RCLootTables;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;

public class UndeadMiner
extends Zombie {
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.m_135353_(UndeadMiner.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public UndeadMiner(EntityType<? extends Zombie> type, Level level) {
        super(type, level);
        this.f_21364_ = 6;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.m_34328_().m_22268_(Attributes.f_22287_, 0.0).m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
    }

    protected boolean m_5884_() {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant().getId());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(Variant.BY_ID[tag.m_128451_("Variant")]);
    }

    public Variant getVariant() {
        return Variant.BY_ID[(Integer)this.f_19804_.m_135370_(DATA_VARIANT)];
    }

    private void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)variant.getId());
    }

    public boolean m_6162_() {
        return false;
    }

    public void m_6863_(boolean baby) {
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        super.m_213945_(random, difficulty);
        Arrays.stream(Variant.values()).filter(variant -> this.getVariant() == variant).forEach(variant -> this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)variant.getPickaxe())));
    }

    public Variant getRandomVariant(RandomSource random, Holder<Biome> biome) {
        int chance = random.m_188503_(50);
        if (chance <= 15) {
            return Variant.IRON;
        }
        if (chance >= 45) {
            return Variant.DIAMOND;
        }
        if (biome.m_203656_(BiomeTags.f_207607_)) {
            return Variant.GOLD;
        }
        return Variant.STONE;
    }

    protected ResourceLocation m_7582_() {
        return switch (this.getVariant().ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 2 -> RCLootTables.UNDEAD_DIAMOND_MINER;
            case 1 -> RCLootTables.UNDEAD_IRON_MINER;
            case 0 -> RCLootTables.UNDEAD_STONE_MINER;
            case 3 -> RCLootTables.UNDEAD_GOLD_MINER;
        };
    }

    protected ItemStack m_5728_() {
        return new ItemStack((ItemLike)RCBlocks.UNDEAD_MINER_HEAD.get());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        this.setVariant(this.getRandomVariant(level.m_213780_(), (Holder<Biome>)level.m_204166_(this.m_20183_())));
        return super.m_6518_(level, difficulty, spawnType, groupData, tag);
    }

    public static boolean checkUndeadMinerSpawnRules(EntityType<UndeadMiner> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return UndeadMiner.m_219013_(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && (spawnType == MobSpawnType.SPAWNER || !level.m_45527_(pos)) && pos.m_123342_() <= (Integer)RottenCreatures.CONFIG.undeadMinerDepth.get();
    }

    public static enum Variant {
        STONE(0, "stone", Items.f_42427_),
        IRON(1, "iron", Items.f_42385_),
        DIAMOND(2, "diamond", Items.f_42390_),
        GOLD(3, "gold", Items.f_42432_);

        public static final Variant[] BY_ID;
        private final int id;
        private final String name;
        private final Item pickaxe;

        private Variant(int id, String name, Item pickaxe) {
            this.id = id;
            this.name = name;
            this.pickaxe = pickaxe;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Item getPickaxe() {
            return this.pickaxe;
        }

        static {
            BY_ID = (Variant[])Arrays.stream(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }
}

