/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.living.scarab;

import com.github.teamfusion.rottencreatures.common.level.entities.living.scarab.ScarabFlyingGoal;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Scarab
extends PathfinderMob {
    private static final EntityDataAccessor<Boolean> DATA_IS_FLYING = SynchedEntityData.m_135353_(Scarab.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_LANDING = SynchedEntityData.m_135353_(Scarab.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.m_135353_(Scarab.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private GroundPathNavigation groundNavigation;
    private FlyingPathNavigation flyingNavigation;
    private int flyingTime = 0;
    private int jumpDelay = 0;
    private int landingTime = 0;
    private static final int LANDING_DURATION = 10;
    private static final int EMBELLISHED_FLIGHT_CHANCE = 15;
    private static final int DEFAULT_FLIGHT_CHANCE = 1;

    public Scarab(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new BeetleMoveControl(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22280_, 0.4).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_FLYING, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_LANDING, (Object)false);
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BeetleMeleeAttackGoal(this, 1.25, false));
        this.f_21345_.m_25352_(2, (Goal)new ScarabFlyingGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BeetleRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected PathNavigation m_6037_(Level level) {
        if (this.isFlying()) {
            if (this.flyingNavigation == null) {
                this.flyingNavigation = new FlyingPathNavigation((Mob)this, level);
                this.flyingNavigation.m_26440_(false);
                this.flyingNavigation.m_7008_(true);
                this.flyingNavigation.m_26443_(true);
            }
            return this.flyingNavigation;
        }
        if (this.groundNavigation == null) {
            this.groundNavigation = new GroundPathNavigation((Mob)this, level);
            this.groundNavigation.m_26477_(false);
            this.groundNavigation.m_7008_(true);
            this.groundNavigation.m_148214_(true);
        }
        return this.groundNavigation;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isLanding()) {
            ++this.landingTime;
            if (this.landingTime >= 10) {
                this.setLanding(false);
                this.landingTime = 0;
            }
        }
        if (this.isFlying() && this.m_20096_() && !this.isLanding()) {
            this.setLanding(true);
            this.setFlying(false);
        }
        if (this.isFlying()) {
            int maxFlyingTime;
            ++this.flyingTime;
            int n = maxFlyingTime = this.isEmbellished() ? 400 : 200;
            if (this.flyingTime > maxFlyingTime && this.f_19796_.m_188503_(100) < 10 && !this.m_5912_()) {
                this.setLanding(true);
                this.setFlying(false);
                this.flyingTime = 0;
            }
            if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
                this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
            }
        } else if (!this.isLanding() && this.m_20096_()) {
            int flightChance;
            int n = flightChance = this.isEmbellished() ? 15 : 1;
            if (--this.jumpDelay <= 0 && !this.m_5912_() && this.f_19796_.m_188503_(100) < flightChance) {
                this.setFlying(true);
                this.jumpDelay = this.isEmbellished() ? 100 + this.f_19796_.m_188503_(200) : 300 + this.f_19796_.m_188503_(300);
                this.m_5997_(0.0, 0.4, 0.0);
            }
            if (this.m_5448_() != null) {
                int combatFlightChance;
                int n2 = combatFlightChance = this.isEmbellished() ? 20 : 3;
                if (this.f_19796_.m_188503_(100) < combatFlightChance) {
                    this.setFlying(true);
                }
            }
        }
    }

    public boolean isLanding() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_LANDING);
    }

    public void setLanding(boolean landing) {
        this.f_19804_.m_135381_(DATA_IS_LANDING, (Object)landing);
    }

    public boolean isEmbellished() {
        return (Integer)this.f_19804_.m_135370_(DATA_VARIANT) == 1;
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)variant);
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_FLYING);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(DATA_IS_FLYING, (Object)flying);
        this.f_21344_ = this.m_6037_(this.m_9236_());
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("IsFlying", this.isFlying());
        tag.m_128379_("IsLanding", this.isLanding());
        tag.m_128405_("Variant", ((Integer)this.f_19804_.m_135370_(DATA_VARIANT)).intValue());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setFlying(tag.m_128471_("IsFlying"));
        this.setLanding(tag.m_128471_("IsLanding"));
        this.setVariant(tag.m_128441_("Variant") ? tag.m_128451_("Variant") : 0);
    }

    protected SoundEvent m_7515_() {
        return this.isFlying() ? SoundEvents.f_11691_ : SoundEvents.f_12419_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12421_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12420_;
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    static class BeetleMoveControl
    extends MoveControl {
        private final Scarab scarab;

        public BeetleMoveControl(Scarab scarab) {
            super((Mob)scarab);
            this.scarab = scarab;
        }

        public void m_8126_() {
            if (this.scarab.isLanding()) {
                super.m_8126_();
                return;
            }
            if (this.scarab.isFlying()) {
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                    double dz;
                    double dy;
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    double dx = this.f_24975_ - this.scarab.m_20185_();
                    double distSq = dx * dx + (dy = this.f_24976_ - this.scarab.m_20186_()) * dy + (dz = this.f_24977_ - this.scarab.m_20189_()) * dz;
                    if (distSq < 2.5E-7) {
                        this.f_24974_.m_21564_(0.0f);
                        return;
                    }
                    float speed = (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22280_));
                    double dist = Math.sqrt(distSq);
                    this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82520_(dx / dist * 0.1 * (double)speed, dy / dist * 0.1 * (double)speed + 0.05, dz / dist * 0.1 * (double)speed));
                    this.f_24974_.m_146922_((float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f);
                    this.f_24974_.m_5618_(this.f_24974_.m_146908_());
                    Vec3 movement = this.f_24974_.m_20184_();
                    double maxSpeed = (double)speed * 0.5;
                    if (movement.m_165925_() > maxSpeed * maxSpeed) {
                        Vec3 capped = movement.m_82541_().m_82490_(maxSpeed);
                        this.f_24974_.m_20334_(capped.f_82479_, movement.f_82480_, capped.f_82481_);
                    }
                } else {
                    this.f_24974_.m_21564_(0.0f);
                    Vec3 motion = this.scarab.m_20184_();
                    this.scarab.m_20256_(motion.m_82542_(0.9, 0.9, 0.9));
                }
            } else {
                super.m_8126_();
            }
        }
    }

    static class BeetleMeleeAttackGoal
    extends MeleeAttackGoal {
        private final Scarab scarab;
        private int ramCooldown = 0;
        private int flyAttemptCooldown = 0;

        public BeetleMeleeAttackGoal(Scarab scarab, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super((PathfinderMob)scarab, speedModifier, followingTargetEvenIfNotSeen);
            this.scarab = scarab;
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.scarab.m_5448_() != null) {
                if (!this.scarab.isEmbellished() && !this.scarab.isFlying() && --this.ramCooldown <= 0 && this.scarab.m_20280_((Entity)this.scarab.m_5448_()) < 10.0 && this.scarab.f_19796_.m_188503_(20) == 0) {
                    Vec3 toTarget = this.scarab.m_5448_().m_20182_().m_82546_(this.scarab.m_20182_()).m_82541_();
                    this.scarab.m_20256_(toTarget.m_82490_(0.8));
                    this.ramCooldown = 60;
                }
                if (this.scarab.isEmbellished() && !this.scarab.isFlying() && !this.scarab.isLanding() && --this.flyAttemptCooldown <= 0) {
                    if (this.scarab.f_19796_.m_188503_(100) < 20) {
                        this.scarab.setFlying(true);
                    }
                    this.flyAttemptCooldown = 20;
                }
            }
        }
    }

    static class BeetleRandomStrollGoal
    extends WaterAvoidingRandomStrollGoal {
        protected final Scarab scarab;

        public BeetleRandomStrollGoal(Scarab scarab, double speedModifier) {
            super((PathfinderMob)scarab, speedModifier);
            this.scarab = scarab;
        }

        @Nullable
        protected Vec3 m_7037_() {
            if (this.scarab.isFlying()) {
                Vec3 forward = this.f_25725_.m_20252_(0.0f);
                Vec3 upward = new Vec3(0.0, 1.0, 0.0);
                Vec3 right = forward.m_82537_(upward).m_82541_();
                forward = forward.m_82490_(this.f_25725_.m_217043_().m_188500_() * 8.0);
                upward = upward.m_82490_(this.f_25725_.m_217043_().m_188500_() * 2.0 - 1.0);
                right = right.m_82490_(this.f_25725_.m_217043_().m_188500_() * 4.0 - 2.0);
                Vec3 target = this.f_25725_.m_20182_().m_82549_(forward).m_82549_(upward).m_82549_(right);
                int minY = this.f_25725_.m_9236_().m_141937_() + 5;
                if (target.f_82480_ < (double)minY) {
                    target = new Vec3(target.f_82479_, (double)minY, target.f_82481_);
                }
                return target;
            }
            if (this.f_25725_.m_20072_()) {
                Vec3 vec3 = LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)15, (int)7);
                return vec3 == null ? super.m_7037_() : vec3;
            }
            return this.f_25725_.m_217043_().m_188501_() >= this.f_25985_ ? LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)10, (int)7) : super.m_7037_();
        }

        public boolean m_8036_() {
            Vec3 vec3;
            if (!this.f_25731_) {
                if (this.f_25725_.m_21216_() >= 100) {
                    return false;
                }
                if (this.f_25725_.m_217043_().m_188503_(BeetleRandomStrollGoal.m_186073_((int)this.f_25730_)) != 0) {
                    return false;
                }
            }
            if ((vec3 = this.m_7037_()) == null) {
                return false;
            }
            this.f_25726_ = vec3.f_82479_;
            this.f_25727_ = vec3.f_82480_;
            this.f_25728_ = vec3.f_82481_;
            this.f_25731_ = false;
            return true;
        }

        public boolean m_8045_() {
            if (this.scarab.isFlying()) {
                return this.f_25725_.m_21573_().m_26572_() && this.f_25725_.m_20275_(this.f_25726_, this.f_25727_, this.f_25728_) > 2.0;
            }
            return super.m_8045_();
        }
    }
}

