/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.living.mummy;

import com.github.teamfusion.rottencreatures.client.registries.RCSoundEvents;
import com.github.teamfusion.rottencreatures.common.level.entities.living.SpellcasterZombie;
import com.github.teamfusion.rottencreatures.common.level.entities.living.scarab.Scarab;
import com.github.teamfusion.rottencreatures.common.registries.RCBlocks;
import com.github.teamfusion.rottencreatures.common.registries.RCEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Mummy
extends SpellcasterZombie {
    private static final EntityDataAccessor<Boolean> DATA_IS_ANCIENT = SynchedEntityData.m_135353_(Mummy.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Mummy(EntityType<? extends SpellcasterZombie> type, Level level) {
        super(type, level);
        this.f_21364_ = 10;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_IS_ANCIENT, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.m_34328_().m_22268_(Attributes.f_22287_, 0.0).m_22268_(Attributes.f_22276_, 26.0).m_22268_(Attributes.f_22279_, 0.18).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new SpellcasterZombie.CastingSpellGoal());
        this.f_21345_.m_25352_(4, (Goal)new SummonScarabsGoal());
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.m_9236_().m_46791_() == Difficulty.NORMAL || this.m_9236_().m_46791_() == Difficulty.HARD) {
            if ((double)this.m_21223_() <= 18.0) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 1200));
            } else if ((double)this.m_21223_() <= 10.0) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 1200, 1));
            } else if ((double)this.m_21223_() <= 6.0) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 1200));
            }
        }
    }

    public boolean m_7327_(Entity entity) {
        boolean hurtTarget = super.m_7327_(entity);
        if (hurtTarget && this.m_21205_().m_41619_() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            float modifier = this.m_9236_().m_6436_(this.m_20183_()).m_19056_();
            living.m_147207_(new MobEffectInstance(MobEffects.f_19612_, 140 * (int)modifier, 2), (Entity)this);
            if (this.f_19796_.m_188499_()) {
                this.summonScarabs(2);
            }
        }
        return hurtTarget;
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        this.summonScarabs(3);
    }

    protected ItemStack m_5728_() {
        return new ItemStack((ItemLike)RCBlocks.MUMMY_HEAD.get());
    }

    private void summonScarabs(int max) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            for (int i = 0; i <= this.f_19796_.m_188503_(max); ++i) {
                BlockPos pos = this.m_20183_().m_7918_(0, 1, 0);
                Scarab scarab = (Scarab)RCEntityTypes.SCARAB.get().m_20615_((Level)server);
                if (scarab == null) continue;
                if (this.isAncient()) {
                    scarab.setVariant(1);
                }
                scarab.m_20035_(pos, 0.0f, 0.0f);
                scarab.m_6518_((ServerLevelAccessor)server, server.m_6436_(pos), MobSpawnType.MOB_SUMMONED, null, null);
                server.m_7967_((Entity)scarab);
            }
        }
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("IsAncient", this.isAncient());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setAncient(tag.m_128471_("IsAncient"));
    }

    public boolean m_6162_() {
        return false;
    }

    public void m_6863_(boolean baby) {
    }

    protected boolean m_5884_() {
        return false;
    }

    public boolean isAncient() {
        return (Boolean)this.m_20088_().m_135370_(DATA_IS_ANCIENT);
    }

    private void setAncient(boolean ancient) {
        this.m_20088_().m_135381_(DATA_IS_ANCIENT, (Object)ancient);
    }

    public static boolean checkMummySpawnRules(EntityType<Mummy> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Mummy.m_219013_(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && (spawnType == MobSpawnType.SPAWNER || level.m_45527_(pos));
    }

    protected SoundEvent m_7515_() {
        return RCSoundEvents.MUMMY_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return RCSoundEvents.MUMMY_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return RCSoundEvents.MUMMY_DEATH.get();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        if (this.f_19796_.m_188501_() <= 0.3f) {
            this.setAncient(true);
        }
        return super.m_6518_(level, difficulty, spawnType, groupData, tag);
    }

    class SummonScarabsGoal
    extends SpellcasterZombie.UseSpellGoal {
        SummonScarabsGoal() {
        }

        @Override
        protected void performSpellCasting() {
            Mummy.this.summonScarabs(5);
        }

        @Override
        protected int getCastingTime() {
            return 60;
        }

        @Override
        protected int getCastingInterval() {
            return Mummy.this.isAncient() ? 260 : 340;
        }

        @Override
        protected int getCastWarmupTime() {
            return 15;
        }
    }
}

