/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.living;

import java.util.EnumSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;

public abstract class SpellcasterZombie
extends Zombie {
    protected int spellCastingTickCount;

    public SpellcasterZombie(EntityType<? extends Zombie> type, Level level) {
        super(type, level);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.spellCastingTickCount = tag.m_128451_("SpellTicks");
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("SpellTicks", this.spellCastingTickCount);
    }

    public boolean isCastingSpell() {
        return this.spellCastingTickCount > 0;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.spellCastingTickCount > 0) {
            --this.spellCastingTickCount;
        }
    }

    protected int getSpellCastingTime() {
        return this.spellCastingTickCount;
    }

    protected abstract class UseSpellGoal
    extends Goal {
        protected int attackWarmupDelay;
        protected int nextAttackTickCount;

        protected UseSpellGoal() {
        }

        public boolean m_8036_() {
            LivingEntity target = SpellcasterZombie.this.m_5448_();
            if (target == null || !target.m_6084_()) {
                return false;
            }
            if (SpellcasterZombie.this.isCastingSpell()) {
                return false;
            }
            return SpellcasterZombie.this.f_19797_ >= this.nextAttackTickCount;
        }

        public boolean m_8045_() {
            LivingEntity target = SpellcasterZombie.this.m_5448_();
            return target != null && target.m_6084_() && this.attackWarmupDelay > 0;
        }

        public void m_8056_() {
            this.attackWarmupDelay = this.m_183277_(this.getCastWarmupTime());
            SpellcasterZombie.this.spellCastingTickCount = this.getCastingTime();
            this.nextAttackTickCount = SpellcasterZombie.this.f_19797_ + this.getCastingInterval();
        }

        public void m_8037_() {
            --this.attackWarmupDelay;
            if (this.attackWarmupDelay == 0) {
                this.performSpellCasting();
            }
        }

        protected abstract void performSpellCasting();

        protected int getCastWarmupTime() {
            return 20;
        }

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();
    }

    protected class CastingSpellGoal
    extends Goal {
        public CastingSpellGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return SpellcasterZombie.this.getSpellCastingTime() > 0;
        }

        public void m_8037_() {
            if (SpellcasterZombie.this.m_5448_() != null) {
                SpellcasterZombie.this.m_21563_().m_24960_((Entity)SpellcasterZombie.this.m_5448_(), (float)SpellcasterZombie.this.m_8085_(), (float)SpellcasterZombie.this.m_8132_());
            }
        }
    }
}

