/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.client.rendering.model.entities;

import com.blackgear.platform.client.animator.MathAnimator;
import com.github.teamfusion.rottencreatures.client.rendering.animation.ScarabAnimations;
import com.github.teamfusion.rottencreatures.common.level.entities.living.scarab.Scarab;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.phys.Vec2;

public class ScarabModel<T extends Scarab>
extends HierarchicalModel<T> {
    public static final String BODY = "body";
    public static final String RIGHT_ELYTRA = "right_elytra";
    public static final String LEFT_ELYTRA = "left_elytra";
    public static final String RIGHT_WING = "right_wing";
    public static final String LEFT_WING = "left_wing";
    public static final String LEFT_FRONT_LEG = "left_front_leg";
    public static final String RIGHT_FRONT_LEG = "right_front_leg";
    public static final String LEFT_MIDDLE_LEG = "left_middle_leg";
    public static final String RIGHT_MIDDLE_LEG = "right_middle_leg";
    public static final String LEFT_BACK_LEG = "left_back_leg";
    public static final String RIGHT_BACK_LEG = "right_back_leg";
    protected final ModelPart root;
    protected final ModelPart body;
    protected final ModelPart elytraRight;
    protected final ModelPart elytraLeft;
    protected final ModelPart wingRight;
    protected final ModelPart wingLeft;
    protected final ModelPart legFrontLeft;
    protected final ModelPart legFrontRight;
    protected final ModelPart legMiddleLeft;
    protected final ModelPart legMiddleRight;
    protected final ModelPart legBackLeft;
    protected final ModelPart legBackRight;

    public ScarabModel(ModelPart root) {
        this.root = root;
        this.body = this.root.m_171324_(BODY);
        this.elytraRight = this.body.m_171324_(RIGHT_ELYTRA);
        this.elytraLeft = this.body.m_171324_(LEFT_ELYTRA);
        this.wingRight = this.body.m_171324_(RIGHT_WING);
        this.wingLeft = this.body.m_171324_(LEFT_WING);
        this.legFrontLeft = this.body.m_171324_(LEFT_FRONT_LEG);
        this.legFrontRight = this.body.m_171324_(RIGHT_FRONT_LEG);
        this.legMiddleLeft = this.body.m_171324_(LEFT_MIDDLE_LEG);
        this.legMiddleRight = this.body.m_171324_(RIGHT_MIDDLE_LEG);
        this.legBackLeft = this.body.m_171324_(LEFT_BACK_LEG);
        this.legBackRight = this.body.m_171324_(RIGHT_BACK_LEG);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition body = root.m_171599_(BODY, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.5f, -3.0f, -6.0f, 7.0f, 3.0f, 4.0f).m_171514_(-2, 24).m_171481_(-2.5f, -1.0f, -8.0f, 5.0f, 0.0f, 2.0f).m_171514_(0, 16).m_171481_(-3.0f, -2.5f, -2.0f, 6.0f, 2.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)1.0f));
        body.m_171599_(RIGHT_ELYTRA, CubeListBuilder.m_171558_().m_171514_(0, 7).m_171481_(-2.0f, 0.0f, 0.0f, 4.0f, 3.0f, 6.0f), PartPose.m_171419_((float)-1.5f, (float)-3.0f, (float)-2.0f));
        body.m_171599_(LEFT_ELYTRA, CubeListBuilder.m_171558_().m_171514_(21, 7).m_171481_(-2.0f, 0.0f, 0.0f, 4.0f, 3.0f, 6.0f), PartPose.m_171419_((float)1.5f, (float)-3.0f, (float)-2.0f));
        body.m_171599_(RIGHT_WING, CubeListBuilder.m_171558_().m_171514_(17, 0).m_171481_(-1.5f, 0.0f, 0.0f, 3.0f, 0.0f, 5.0f), PartPose.m_171419_((float)1.5f, (float)-2.75f, (float)-2.0f));
        body.m_171599_(LEFT_WING, CubeListBuilder.m_171558_().m_171514_(23, 0).m_171481_(-1.5f, 0.0f, 0.0f, 3.0f, 0.0f, 5.0f), PartPose.m_171419_((float)-1.5f, (float)-2.75f, (float)-2.0f));
        body.m_171599_(LEFT_FRONT_LEG, CubeListBuilder.m_171558_().m_171514_(1, 27).m_171481_(-0.5f, 0.0f, -4.5f, 3.0f, 0.0f, 5.0f), PartPose.m_171419_((float)4.0f, (float)-0.1f, (float)-2.5f));
        body.m_171599_(RIGHT_FRONT_LEG, CubeListBuilder.m_171558_().m_171514_(-5, 27).m_171481_(-2.5f, 0.0f, -4.5f, 3.0f, 0.0f, 5.0f), PartPose.m_171419_((float)-4.0f, (float)-0.1f, (float)-2.5f));
        body.m_171599_(LEFT_MIDDLE_LEG, CubeListBuilder.m_171558_().m_171514_(5, 33).m_171481_(0.0f, 0.0f, -0.5f, 4.0f, 0.0f, 3.0f), PartPose.m_171419_((float)3.5f, (float)-0.1f, (float)-0.5f));
        body.m_171599_(RIGHT_MIDDLE_LEG, CubeListBuilder.m_171558_().m_171514_(-3, 33).m_171481_(-4.0f, 0.0f, -0.5f, 4.0f, 0.0f, 3.0f), PartPose.m_171419_((float)-3.5f, (float)-0.1f, (float)-0.5f));
        body.m_171599_(LEFT_BACK_LEG, CubeListBuilder.m_171558_().m_171514_(-1, 37).m_171481_(0.0f, 0.0f, -0.5f, 2.0f, 0.0f, 5.0f), PartPose.m_171419_((float)3.5f, (float)-0.1f, (float)1.5f));
        body.m_171599_(RIGHT_BACK_LEG, CubeListBuilder.m_171558_().m_171514_(-5, 37).m_171481_(-2.0f, 0.0f, -0.5f, 2.0f, 0.0f, 5.0f), PartPose.m_171419_((float)-3.5f, (float)-0.1f, (float)1.5f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)41, (int)42);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        boolean isInAir;
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        boolean isMoving = (double)new Vec2((float)entity.m_20184_().f_82479_, (float)entity.m_20184_().f_82481_).m_165907_() > 0.01;
        boolean bl = isInAir = !entity.m_20096_() && !entity.m_20072_();
        if (isInAir) {
            MathAnimator.animate((HierarchicalModel)this, (float)animationProgress, (MathAnimator)ScarabAnimations.FLYING);
        } else if (isMoving) {
            MathAnimator.animate((HierarchicalModel)this, (float)animationProgress, (MathAnimator)ScarabAnimations.WALK);
        }
    }
}

