/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class SporeEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(SporeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> STUCK = SynchedEntityData.m_135353_(SporeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> LIFETIME = SynchedEntityData.m_135353_(SporeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.m_135353_(SporeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    public void setSize(float amount) {
        this.m_20088_().m_135381_(SIZE, (Object)Float.valueOf(amount));
    }

    public float getSize() {
        return ((Float)this.m_20088_().m_135370_(SIZE)).floatValue();
    }

    public void setStuck(boolean value) {
        this.m_20088_().m_135381_(STUCK, (Object)value);
    }

    public boolean isStuck() {
        return (Boolean)this.m_20088_().m_135370_(STUCK);
    }

    public void setLifetime(int amount) {
        this.m_20088_().m_135381_(LIFETIME, (Object)amount);
    }

    public int getLifetime() {
        return (Integer)this.m_20088_().m_135370_(LIFETIME);
    }

    public void setStack(ItemStack stack) {
        this.m_20088_().m_135381_(STACK, (Object)stack);
    }

    public ItemStack getStack() {
        return (ItemStack)this.m_20088_().m_135370_(STACK);
    }

    public SporeEntity(EntityType<? extends ThrowableProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        ItemStack stack = this.getStack();
        Item item = stack.m_41720_();
        if (!(item instanceof IRelicItem)) {
            this.m_146870_();
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        if (this.isStuck()) {
            this.m_20334_(0.0, 0.0, 0.0);
        }
        if (!(level = this.m_9236_()).m_5776_()) {
            if (this.isStuck()) {
                this.setLifetime(this.getLifetime() + 1);
            }
            if ((double)this.getLifetime() > relic.getAbilityValue(stack, "spore", "duration") * 20.0) {
                this.m_146870_();
            }
        }
        RandomSource random = level.m_213780_();
        double inlinedSize = Math.pow(Math.log10(1.0f + this.getSize()), 0.3333333333333333);
        if (this.isStuck()) {
            ParticleUtils.createBall(ParticleUtils.constructSimpleSpark(new Color(random.m_188503_(200), 255, 0), (float)(inlinedSize * 0.25), 40, 0.95f), this.m_20182_().m_82520_(0.0, inlinedSize / 6.0, 0.0), level, 0, (float)(inlinedSize * (double)0.025f));
        } else {
            level.m_7106_(ParticleUtils.constructSimpleSpark(new Color(random.m_188503_(200), 255, 0), (float)(inlinedSize * 0.25), 40, 0.9f), this.m_20185_(), this.m_20186_() + inlinedSize / 6.0, this.m_20189_(), (double)(MathUtils.randomFloat(random) * 0.025f), (double)(MathUtils.randomFloat(random) * 0.025f), (double)(MathUtils.randomFloat(random) * 0.025f));
        }
        Entity entity = this.m_19749_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.isStuck()) {
            for (LivingEntity entity2 : level.m_45976_(LivingEntity.class, this.m_20191_())) {
                if (entity2.m_20149_().equals(player.m_20149_())) continue;
                this.setLifetime((int)Math.max((long)this.getLifetime(), Math.round(relic.getAbilityValue(stack, "spore", "duration") * 20.0) - 20L));
                break;
            }
        }
    }

    protected void m_8060_(BlockHitResult result) {
        this.m_20334_(0.0, 0.0, 0.0);
        this.setStuck(true);
    }

    public void onRemovedFromWorld() {
        ItemStack stack = this.getStack();
        Item item = stack.m_41720_();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12291_, SoundSource.MASTER, 1.0f, 1.0f + this.f_19796_.m_188501_());
        double inlinedSize = Math.pow(Math.log10(1.0f + this.getSize()), 0.3333333333333333);
        ParticleUtils.createBall(ParticleUtils.constructSimpleSpark(new Color(100 + this.m_9236_().m_213780_().m_188503_(50), 255, 0), (float)(inlinedSize * (double)0.35f), 40, 0.9f), this.m_20182_().m_82520_(0.0, inlinedSize / 3.0, 0.0), this.m_9236_(), (int)Math.ceil(1.0 + inlinedSize), (float)(inlinedSize / 2.0));
        Entity entity = this.m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            RandomSource random = player.m_217043_();
            for (LivingEntity entity2 : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(1.0 + Math.pow(Math.log10(1.0f + this.getSize()), 0.3333333333333333) / 2.0))) {
                if (entity2.m_20149_().equals(player.m_20149_()) || !EntityUtils.hurt(entity2, this.m_9236_().m_269111_().m_269390_((Entity)this, (Entity)player), (float)((double)this.getSize() * relic.getAbilityValue(stack, "spore", "damage")))) continue;
                entity2.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100));
                entity2.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100));
                entity2.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.ANTI_HEAL.get(), 100));
            }
            if (this.getSize() >= 1.0f) {
                int count = (int)Math.ceil(Math.pow(this.getSize(), relic.getAbilityValue(stack, "multiplying", "amount")));
                for (int i = 0; i < count && !((double)random.m_188501_() > relic.getAbilityValue(stack, "multiplying", "chance")); ++i) {
                    float mul = this.m_20206_() / 1.5f;
                    float speed = 0.1f + random.m_188501_() * 0.2f;
                    Vec3 motion = new Vec3((double)(MathUtils.randomFloat(random) * speed), (double)speed, (double)(MathUtils.randomFloat(random) * speed));
                    SporeEntity spore = new SporeEntity((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.SPORE.get()), this.m_9236_());
                    spore.m_5602_((Entity)player);
                    spore.setStack(stack);
                    spore.m_20256_(motion);
                    spore.m_146884_(this.m_20182_().m_82520_(0.0, (double)mul, 0.0).m_82549_(motion.m_82541_().m_82490_((double)mul)));
                    spore.setSize((float)((double)this.getSize() * relic.getAbilityValue(stack, "multiplying", "size")));
                    this.m_9236_().m_7967_((Entity)spore);
                    relic.spreadExperience((LivingEntity)player, stack, 1);
                }
            }
        }
        super.onRemovedFromWorld();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(0.5f));
        this.f_19804_.m_135372_(LIFETIME, (Object)0);
        this.f_19804_.m_135372_(STUCK, (Object)false);
        this.f_19804_.m_135372_(STACK, (Object)ItemStack.f_41583_);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setSize(compound.m_128457_("size"));
        this.setStuck(compound.m_128471_("stuck"));
        this.setLifetime(compound.m_128451_("lifetime"));
        this.setStack(ItemStack.m_41712_((CompoundTag)compound.m_128469_("stack")));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("size", this.getSize());
        compound.m_128379_("stuck", this.isStuck());
        compound.m_128405_("lifetime", this.getLifetime());
        this.getStack().m_41739_(compound.m_128469_("stack"));
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (SIZE.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    public EntityDimensions m_6972_(Pose pPose) {
        float inlinedSize = (float)Math.pow(Math.log10(1.0f + this.getSize()), 0.3333333333333333);
        return EntityDimensions.m_20395_((float)(inlinedSize / 2.0f), (float)(inlinedSize / 2.0f));
    }
}

