/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.handlers.hook.server;

import com.oe.rehooked.data.AdditionalHandlersRegistry;
import com.oe.rehooked.entities.hook.HookEntity;
import com.oe.rehooked.handlers.additional.def.IServerHandler;
import com.oe.rehooked.handlers.hook.def.ICommonPlayerHookHandler;
import com.oe.rehooked.handlers.hook.def.IServerPlayerHookHandler;
import com.oe.rehooked.handlers.hook.server.FlightHandler;
import com.oe.rehooked.network.handlers.PacketHandler;
import com.oe.rehooked.network.packets.client.CHookCapabilityPacket;
import com.oe.rehooked.utils.CurioUtils;
import com.oe.rehooked.utils.PositionHelper;
import com.oe.rehooked.utils.VectorHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class SPlayerHookHandler
implements IServerPlayerHookHandler {
    private final List<HookEntity> hooks = new ArrayList<HookEntity>();
    private Optional<ServerPlayer> owner = Optional.empty();
    private Vec3 moveVector = null;
    private Vec3 momentum;
    private Vec3 lastPlayerPosition;
    private FlightHandler flightHandler = new FlightHandler();
    private IServerHandler additional;

    @Override
    public void addHook(int id) {
        this.getOwner().map(Entity::m_9236_).map(level -> level.m_6815_(id)).map(entity -> {
            if (entity instanceof HookEntity) {
                HookEntity hookEntity = (HookEntity)((Object)entity);
                this.hooks.add(hookEntity);
                return hookEntity;
            }
            return null;
        }).flatMap(hookEntity -> this.getOwner()).ifPresent(owner -> PacketHandler.sendToPlayer(new CHookCapabilityPacket(CHookCapabilityPacket.State.ADD_HOOK, id), owner));
    }

    @Override
    public void addHook(HookEntity hookEntity) {
        this.hooks.add(hookEntity);
        this.getOwner().ifPresent(owner -> PacketHandler.sendToPlayer(new CHookCapabilityPacket(CHookCapabilityPacket.State.ADD_HOOK, hookEntity.m_19879_()), owner));
    }

    @Override
    public void removeHook(int id) {
        if (this.hooks.removeIf(hookEntity -> hookEntity.m_19879_() == id)) {
            this.getOwner().ifPresent(owner -> {
                Entity patt2823$temp = owner.m_9236_().m_6815_(id);
                if (patt2823$temp instanceof HookEntity) {
                    HookEntity hookEntity = (HookEntity)patt2823$temp;
                    hookEntity.setReason(HookEntity.Reason.PLAYER);
                    hookEntity.setState(HookEntity.State.RETRACTING);
                }
            });
        }
    }

    @Override
    public void removeHook(HookEntity hookEntity) {
        if (this.hooks.remove((Object)hookEntity)) {
            this.getOwner().ifPresent(owner -> PacketHandler.sendToPlayer(new CHookCapabilityPacket(CHookCapabilityPacket.State.RETRACT_HOOK, hookEntity.m_19879_()), owner));
            if (hookEntity.getState().equals((Object)HookEntity.State.RETRACTING)) {
                hookEntity.setReason(HookEntity.Reason.EMPTY);
                hookEntity.setState(HookEntity.State.DONE);
            } else {
                hookEntity.setReason(HookEntity.Reason.PLAYER);
                hookEntity.setState(HookEntity.State.RETRACTING);
            }
        }
    }

    @Override
    public void removeAllHooks() {
        this.hooks.forEach(hookEntity -> {
            hookEntity.setReason(HookEntity.Reason.PLAYER);
            hookEntity.setState(HookEntity.State.RETRACTING);
        });
        this.hooks.clear();
    }

    @Override
    public void shootFromRotation(float xRot, float yRot) {
        this.getOwner().ifPresent(owner -> this.getHookData().ifPresent(hookData -> {
            if (this.hooks.size() + 1 > hookData.count()) {
                this.removeHook(this.hooks.get(0));
            }
            HookEntity hookEntity = new HookEntity((Player)owner);
            owner.m_9236_().m_7967_((Entity)hookEntity);
            this.addHook(hookEntity);
            hookEntity.m_37251_((Entity)owner, xRot, yRot, 0.0f, Math.min(hookData.speed() / 20.0f, hookData.range()), 0.0f);
        }));
    }

    @Override
    public ICommonPlayerHookHandler setOwner(Player owner) {
        this.owner = Optional.of((ServerPlayer)owner);
        return this;
    }

    public Optional<ServerPlayer> getOwner() {
        return this.owner;
    }

    @Override
    public void afterDeath() {
        this.owner.ifPresent(player -> {
            IServerPlayerHookHandler.super.afterDeath();
            this.flightHandler.afterDeath((ServerPlayer)player);
            this.update();
        });
    }

    @Override
    public void update() {
        this.moveVector = null;
        this.getOwner().ifPresent(owner -> {
            this.flightHandler.updateFlight((ServerPlayer)owner, this);
            if (this.additional != null) {
                this.additional.update();
            }
            boolean[] creative = new boolean[]{false};
            this.getHookData().ifPresent(hookData -> {
                if (this.countPulling() == 0) {
                    return;
                }
                owner.m_183634_();
                owner.m_6853_(false);
                float vPT = hookData.pullSpeed() / 20.0f;
                Vec3 ownerWaistPos = PositionHelper.getWaistPosition((Entity)owner);
                if (!hookData.isCreative()) {
                    Vec3 pullCenter = this.getPullCenter();
                    double x = pullCenter.f_82479_ - ownerWaistPos.f_82479_;
                    double y = pullCenter.f_82480_ - ownerWaistPos.f_82480_;
                    double z = pullCenter.f_82481_ - ownerWaistPos.f_82481_;
                    this.moveVector = new Vec3(x, y, z);
                } else {
                    creative[0] = true;
                    List<HookEntity> list = this.getHooks().stream().filter(entity -> entity.m_20182_().m_82554_(ownerWaistPos) > (double)hookData.range() * 2.2).toList();
                    for (HookEntity hookEntity : list) {
                        this.removeHook(hookEntity);
                        this.killHook(hookEntity.m_19879_());
                    }
                    if (this.countPulling() == 0) {
                        return;
                    }
                    VectorHelper.Box box = this.getBox();
                    if (!box.isInside(ownerWaistPos)) {
                        this.moveVector = ownerWaistPos.m_82505_(box.closestPointInCube(ownerWaistPos));
                    } else {
                        return;
                    }
                }
                this.moveVector = this.reduceCollisions(this.moveVector);
                if (this.moveVector.m_82553_() > (double)vPT) {
                    this.moveVector = this.moveVector.m_82541_().m_82490_((double)vPT);
                }
                if (this.moveVector.m_82553_() < 0.2) {
                    this.moveVector = Vec3.f_82478_;
                }
            });
            this.updateMomentum();
            boolean renderParticles = creative[0] || this.actualPlayerPositionChange().m_82553_() > 0.2;
            this.getHooks().forEach(hookEntity -> hookEntity.setRenderParticles(renderParticles));
        });
    }

    @Override
    public boolean shouldMoveThisTick() {
        return this.moveVector != null;
    }

    @Override
    public Vec3 getDeltaVThisTick() {
        return this.moveVector;
    }

    @Override
    public Collection<HookEntity> getHooks() {
        return this.hooks;
    }

    @Override
    public void setDeltaVThisTick(Vec3 dV) {
        this.moveVector = dV;
    }

    @Override
    public Vec3 getMomentum() {
        return this.momentum;
    }

    @Override
    public void setMomentum(Vec3 momentum) {
        this.momentum = momentum;
    }

    @Override
    public Optional<Vec3> getLastPlayerPosition() {
        return Optional.ofNullable(this.lastPlayerPosition);
    }

    @Override
    public void storeLastPlayerPosition() {
        this.getOwner().ifPresent(owner -> {
            this.lastPlayerPosition = owner.m_20182_();
        });
    }

    @Override
    public void removeAllClientHooks() {
        this.owner.ifPresent(player -> PacketHandler.sendToPlayer(new CHookCapabilityPacket(CHookCapabilityPacket.State.RETRACT_ALL_HOOKS), player));
    }

    @Override
    public void copyFrom(IServerPlayerHookHandler handler) {
        if (handler instanceof SPlayerHookHandler) {
            SPlayerHookHandler other = (SPlayerHookHandler)handler;
            this.flightHandler = other.flightHandler;
        }
    }

    @Override
    public void onUnequip() {
        IServerPlayerHookHandler.super.onUnequip();
        this.additional = null;
    }

    @Override
    public void onEquip() {
        IServerPlayerHookHandler.super.onEquip();
        this.additional = null;
        this.owner.flatMap(CurioUtils::getHookType).flatMap(AdditionalHandlersRegistry::getHandler).ifPresent(cl -> {
            try {
                this.additional = (IServerHandler)cl.getDeclaredConstructor(IServerPlayerHookHandler.class).newInstance(this);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        });
    }
}

