/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.config.client.visuals;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.common.ForgeConfigSpec;

public class HookVisualsConfig {
    public static final String PARTICLES = "particles";
    public static final String CHAIN = "chain";
    private static final Map<String, ForgeConfigSpec.ConfigValue<String>> CHAIN_PARTICLE_SETTINGS = new HashMap<String, ForgeConfigSpec.ConfigValue<String>>();

    public static void init(ForgeConfigSpec.Builder builder) {
        builder.push("visuals");
        List<String> chainOrParticle = List.of(PARTICLES, CHAIN);
        ForgeConfigSpec.ConfigValue blazeHookLink = builder.comment("Should the blaze hook use the chain or particle effect? " + chainOrParticle).defineInList("blaze_hook_link", (Object)PARTICLES, chainOrParticle);
        CHAIN_PARTICLE_SETTINGS.put("blaze", (ForgeConfigSpec.ConfigValue<String>)blazeHookLink);
        ForgeConfigSpec.ConfigValue enderHookLink = builder.comment("Should the ender hook use the chain or particle effect? " + chainOrParticle).defineInList("ender_hook_link", (Object)PARTICLES, chainOrParticle);
        CHAIN_PARTICLE_SETTINGS.put("ender", (ForgeConfigSpec.ConfigValue<String>)enderHookLink);
        builder.pop();
    }

    public static Optional<ForgeConfigSpec.ConfigValue<String>> getChainSetting(String hookType) {
        return Optional.ofNullable(CHAIN_PARTICLE_SETTINGS.get(hookType));
    }
}

