/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.mixin;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestButton;
import dev.ftb.mods.ftbquests.quest.QuestLink;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import java.util.List;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import questsadditions.mixinutils.IMixinQuest;

@Mixin(value={QuestButton.class})
public abstract class MixinQuestButton {
    @Redirect(method={"draw"}, at=@At(value="INVOKE", target="Ldev/ftb/mods/ftblibrary/icon/ImageIcon;withColor(Ldev/ftb/mods/ftblibrary/icon/Color4I;)Ldev/ftb/mods/ftblibrary/icon/ImageIcon;", ordinal=2), remap=false)
    private ImageIcon withColorProxy(ImageIcon icon, Color4I color) {
        QuestObject questObject = this.theQuestObject();
        if (questObject instanceof QuestLink) {
            return ((QuestLink)questObject).getQuest().map(quest -> this.defineIncompatibleQuestsColor(icon, color, (QuestObject)quest)).orElseGet(() -> icon.withColor(color));
        }
        return this.defineIncompatibleQuestsColor(icon, color, questObject);
    }

    private ImageIcon defineIncompatibleQuestsColor(ImageIcon icon, Color4I color, QuestObject questObject) {
        List<QuestObject> incompatibleQuests;
        if (questObject instanceof IMixinQuest && !(incompatibleQuests = ((IMixinQuest)questObject).getIncompatibleQuests()).isEmpty()) {
            int fcolor = 0;
            for (QuestObject quest : incompatibleQuests) {
                fcolor ^= (int)quest.id;
            }
            return icon.withColor(Color4I.rgb((int)fcolor).addBrightness(0.3f));
        }
        return icon.withColor(color);
    }

    @Shadow
    public abstract QuestObject theQuestObject();
}

