/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.mixin;

import de.cadentem.quality_food.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractFurnaceBlockEntity.class})
public abstract class AbstractFurnaceBlockEntityMixin
extends BaseContainerBlockEntity {
    protected AbstractFurnaceBlockEntityMixin(BlockEntityType<?> type, BlockPos position, BlockState state) {
        super(type, position, state);
    }

    @Inject(method={"serverTick"}, at={@At(value="TAIL")})
    private static void quality_food$handleParticles(Level level, BlockPos position, BlockState state, AbstractFurnaceBlockEntity blockEntity, CallbackInfo callback) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Utils.sendParticles(serverLevel, (BlockEntity)blockEntity, position);
        }
    }

    @Inject(method={"burn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;shrink(I)V", shift=At.Shift.BEFORE)})
    private void quality_food$incrementQuality(RegistryAccess access, Recipe<?> recipe, NonNullList<ItemStack> stacks, int stackSize, CallbackInfoReturnable<Boolean> callback) {
        Utils.incrementQuality((BlockEntity)this, (ItemStack)stacks.get(0));
    }
}

