/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.core.loot_modifiers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cadentem.quality_food.util.QualityUtils;
import de.cadentem.quality_food.util.Utils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class QualityLootModifier
extends LootModifier {
    public static final String ID = "quality_loot_modifier";
    public static final Codec<QualityLootModifier> CODEC = RecordCodecBuilder.create(instance -> LootModifier.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, QualityLootModifier::new));

    public QualityLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (generatedLoot.isEmpty() || !this.isValidLootTable(context)) {
            return generatedLoot;
        }
        generatedLoot.stream().filter(Utils::isValidItem).forEach(stack -> {
            Player player;
            Object patt1631$temp = context.m_78953_(LootContextParams.f_81455_);
            QualityUtils.applyQuality(stack, patt1631$temp instanceof Player ? (player = (Player)patt1631$temp) : null);
        });
        return generatedLoot;
    }

    private boolean isValidLootTable(LootContext context) {
        return context.getQueriedLootTableId().m_135815_().startsWith("chest");
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

