/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.core;

import de.cadentem.quality_food.config.QualityConfig;
import de.cadentem.quality_food.config.ServerConfig;
import de.cadentem.quality_food.core.Quality;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public record Modification(Type type, float amount) {
    public static final Modification NONE = Modification.additive(0.0f);

    public static Modification additive(float amount) {
        return new Modification(Type.ADDITIVE, amount);
    }

    public static Modification multiplicative(float amount) {
        return new Modification(Type.MULTIPLICATIVE, amount);
    }

    public double apply(double chance) {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.ADDITIVE -> chance + (double)this.amount;
            case Type.MULTIPLICATIVE -> chance * (double)this.amount;
        };
    }

    public static Modification luck(@Nullable Player player) {
        if (player == null) {
            return NONE;
        }
        float multiplier = (float)(player.m_21133_(Attributes.f_22286_) * (Double)ServerConfig.LUCK_MULTIPLIER.get());
        return Modification.multiplicative(Math.max(1.0f, multiplier));
    }

    public static Modification harvestOrSeedMultiplier(Quality quality, ItemStack stack) {
        if (stack.m_204117_(Tags.Items.CROPS)) {
            return Modification.multiplicative(QualityConfig.getCropMultiplier(quality));
        }
        if (stack.m_204117_(Tags.Items.SEEDS)) {
            return Modification.multiplicative(QualityConfig.getSeedMultiplier(quality));
        }
        return NONE;
    }

    public static Modification farmland(BlockState crop, @Nullable BlockState farmland) {
        if (farmland == null) {
            return NONE;
        }
        return Modification.multiplicative(ServerConfig.getFarmlandMultiplier(crop, farmland));
    }

    public static enum Type {
        ADDITIVE,
        MULTIPLICATIVE;

    }
}

