/*
 * Decompiled with CFR 0.152.
 */
package com.prunoideae.powerfuljs.capabilities.forge.mods.botania;

import com.prunoideae.powerfuljs.capabilities.forge.CapabilityBuilderForge;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.item.Relic;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.relic.RelicImpl;

public class CapabilityRelic {
    public NormalRelicBuilder normalRelic() {
        return this.normalRelic(null);
    }

    public NormalRelicBuilder normalRelic(ResourceLocation advancement) {
        return new NormalRelicBuilder(advancement);
    }

    public CustomRelicBuilder customRelic() {
        return new CustomRelicBuilder();
    }

    public void addRelicTooltipForItem(ItemStack stack, List<Component> tooltip) {
        RelicImpl.addDefaultTooltip((ItemStack)stack, tooltip);
    }

    public static class NormalRelicBuilder
    extends CapabilityBuilderForge<ItemStack, Relic> {
        private final ResourceLocation advancement;

        public NormalRelicBuilder(ResourceLocation advancement) {
            this.advancement = advancement;
        }

        @Override
        public Relic getCapability(ItemStack instance) {
            return new RelicImpl(instance, this.advancement);
        }

        @Override
        public Capability<Relic> getCapabilityKey() {
            return BotaniaForgeCapabilities.RELIC;
        }

        @Override
        public ResourceLocation getResourceLocation() {
            return new ResourceLocation("powerful:relic_botania");
        }
    }

    public static class CustomRelicBuilder
    extends CapabilityBuilderForge<ItemStack, Relic> {
        private static final String TAG_SOULBIND_UUID = "soulbindUUID";
        private RelicTick tick;
        private ResourceLocation advancement;
        private boolean shouldDamageWrongPlayer = true;

        public CustomRelicBuilder setAdvancement(ResourceLocation advancement) {
            this.advancement = advancement;
            return this;
        }

        public CustomRelicBuilder shouldDamageWrongPlayer(boolean shouldDamageWrongPlayer) {
            this.shouldDamageWrongPlayer = shouldDamageWrongPlayer;
            return this;
        }

        public CustomRelicBuilder onTick(RelicTick tick) {
            this.tick = tick;
            return this;
        }

        @Override
        @HideFromJS
        public Relic getCapability(final ItemStack instance) {
            return new Relic(){

                public void bindToUUID(UUID uuid) {
                    ItemNBTHelper.setString((ItemStack)instance, (String)CustomRelicBuilder.TAG_SOULBIND_UUID, (String)uuid.toString());
                }

                @Nullable
                public UUID getSoulbindUUID() {
                    if (ItemNBTHelper.verifyExistance((ItemStack)instance, (String)CustomRelicBuilder.TAG_SOULBIND_UUID)) {
                        try {
                            return UUID.fromString(ItemNBTHelper.getString((ItemStack)instance, (String)CustomRelicBuilder.TAG_SOULBIND_UUID, (String)""));
                        }
                        catch (IllegalArgumentException ex) {
                            ItemNBTHelper.removeEntry((ItemStack)instance, (String)CustomRelicBuilder.TAG_SOULBIND_UUID);
                        }
                    }
                    return null;
                }

                public void tickBinding(Player player) {
                    if (tick != null) {
                        tick.tick(instance, this, player);
                    }
                }

                public boolean isRightPlayer(Player player) {
                    return player.m_20148_().equals(this.getSoulbindUUID());
                }

                @Nullable
                public ResourceLocation getAdvancement() {
                    return advancement;
                }

                public boolean shouldDamageWrongPlayer() {
                    return shouldDamageWrongPlayer;
                }
            };
        }

        @Override
        @HideFromJS
        public Capability<Relic> getCapabilityKey() {
            return BotaniaForgeCapabilities.RELIC;
        }

        @Override
        @HideFromJS
        public ResourceLocation getResourceLocation() {
            return new ResourceLocation("powerful:relic_custom_botania");
        }
    }

    @FunctionalInterface
    public static interface RelicTick {
        public void tick(ItemStack var1, Relic var2, Player var3);
    }
}

