/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.richiesta_contenuto;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import nimble.portable_blueprints.init.ModGameRules;
import nimble.portable_blueprints.network.PacketHandler;
import nimble.portable_blueprints.network.richiesta_contenuto.StoC_RichiestaGamerule;

public class CtoS_RichiestaGamerule {
    private final int idRichesta;
    private final TipoRichiesta tipoRichiesta;

    public CtoS_RichiestaGamerule() {
        this.idRichesta = -1;
        this.tipoRichiesta = null;
    }

    public CtoS_RichiestaGamerule(int idRichesta, TipoRichiesta tipoRichiesta) {
        this.idRichesta = idRichesta;
        this.tipoRichiesta = tipoRichiesta;
    }

    public CtoS_RichiestaGamerule(FriendlyByteBuf buffer) {
        this.idRichesta = buffer.readInt();
        this.tipoRichiesta = (TipoRichiesta)buffer.m_130066_(TipoRichiesta.class);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.idRichesta);
        buffer.m_130068_((Enum)this.tipoRichiesta);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ServerLevel level = player.m_284548_();
            switch (this.tipoRichiesta) {
                case MAX_BLUEPRINTS_FOR_PLAYER: {
                    PacketHandler.sendToPlayer(new StoC_RichiestaGamerule(this.idRichesta, level.m_6106_().m_5470_().m_46215_(ModGameRules.Max_Blueprints_for_player)), player);
                    break;
                }
                case MAX_STRUCTURE_BLOCK_COUNT: {
                    PacketHandler.sendToPlayer(new StoC_RichiestaGamerule(this.idRichesta, level.m_6106_().m_5470_().m_46215_(ModGameRules.MaxScannerBlockCount)), player);
                    break;
                }
                case ALLOW_GLOBAL_BLUEPRINTS: {
                    PacketHandler.sendToPlayer(new StoC_RichiestaGamerule(this.idRichesta, level.m_6106_().m_5470_().m_46207_(ModGameRules.AllowGlobalBlueprints)), player);
                }
            }
        });
        return true;
    }

    public static enum TipoRichiesta {
        MAX_BLUEPRINTS_FOR_PLAYER,
        MAX_STRUCTURE_BLOCK_COUNT,
        ALLOW_GLOBAL_BLUEPRINTS;

    }
}

