/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.forge.inventory.power;

import net.creeperhost.polylib.forge.inventory.power.PolyForgeEnergyWrapper;
import net.creeperhost.polylib.inventory.power.PolyEnergyBlock;
import net.creeperhost.polylib.inventory.power.PolyEnergyItem;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyCapProvider
implements ICapabilityProvider {
    private PolyEnergyBlock energyBlock;
    private PolyEnergyItem item;
    private ItemStack stack;

    public EnergyCapProvider(PolyEnergyBlock energyBlock) {
        this.energyBlock = energyBlock;
    }

    public EnergyCapProvider(PolyEnergyItem item, ItemStack stack) {
        this.item = item;
        this.stack = stack;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
        if (capability == ForgeCapabilities.ENERGY) {
            if (this.energyBlock != null) {
                if (this.energyBlock.getEnergyStorage(arg) == null) {
                    return LazyOptional.empty();
                }
                return LazyOptional.of(() -> new PolyForgeEnergyWrapper(this.energyBlock.getEnergyStorage(arg))).cast();
            }
            if (this.stack != null) {
                if (this.item.getEnergyStorage(this.stack) == null) {
                    return LazyOptional.empty();
                }
                return LazyOptional.of(() -> new PolyForgeEnergyWrapper(this.item.getEnergyStorage(this.stack))).cast();
            }
        }
        return LazyOptional.empty();
    }
}

