/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.containers.slots;

import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class PolySlot
extends Slot {
    private boolean canPlace = true;
    private boolean checkContainer = true;
    private Supplier<Boolean> enabled = () -> true;
    private Predicate<ItemStack> validator = stack -> true;
    private Function<ItemStack, Integer> stackLimit = stack -> Integer.MAX_VALUE;
    private BiPredicate<Player, ItemStack> canRemove = (player, stack) -> true;
    private BiConsumer<ItemStack, ItemStack> onSetByPlayer = (oldStack, newStack) -> {};

    public PolySlot(Container container, int index) {
        this(container, index, 0, 0);
    }

    public PolySlot(Container container, int index, int xPos, int yPos) {
        super(container, index, xPos, yPos);
    }

    public PolySlot output() {
        this.canPlace = false;
        return this;
    }

    public PolySlot noCheck() {
        this.checkContainer = false;
        return this;
    }

    public PolySlot setValidator(Predicate<ItemStack> validator) {
        this.validator = validator;
        return this;
    }

    public PolySlot onSetByPlayer(BiConsumer<ItemStack, ItemStack> onSetByPlayer) {
        this.onSetByPlayer = onSetByPlayer;
        return this;
    }

    public PolySlot setStackLimit(Function<ItemStack, Integer> stackLimit) {
        this.stackLimit = stackLimit;
        return this;
    }

    public PolySlot setCanRemove(BiPredicate<Player, ItemStack> canRemove) {
        this.canRemove = canRemove;
        return this;
    }

    public PolySlot setEnabled(Supplier<Boolean> enabled) {
        this.enabled = enabled;
        return this;
    }

    public PolySlot setEnabled(boolean enabled) {
        this.enabled = () -> enabled;
        return this;
    }

    public boolean m_5857_(ItemStack itemStack) {
        return this.canPlace && this.validator.test(itemStack) && (!this.checkContainer || this.f_40218_.m_7013_(this.m_150661_(), itemStack));
    }

    public boolean m_8010_(Player player) {
        return this.canRemove.test(player, this.m_7993_());
    }

    public void m_269060_(ItemStack itemStack) {
        this.onSetByPlayer.accept(this.m_7993_(), itemStack);
        super.m_269060_(itemStack);
    }

    public boolean m_6659_() {
        return this.enabled.get();
    }

    public int m_5866_(ItemStack itemStack) {
        return Math.min(super.m_5866_(itemStack), this.stackLimit.apply(itemStack));
    }
}

