/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.StonecutterUtil;
import pigcart.particlerain.config.ModConfig;
import pigcart.particlerain.mixin.access.ParticleEngineAccessor;
import pigcart.particlerain.particle.CustomParticle;

public final class WeatherParticleManager {
    public static ParticleGroup particleGroup = new ParticleGroup(ModConfig.CONFIG.perf.maxParticleAmount);
    public static int fogCount;
    private static final BlockPos.MutableBlockPos pos;
    private static final BlockPos.MutableBlockPos heightmapPos;

    public static int getParticleCount() {
        ParticleEngineAccessor particleEngine = (ParticleEngineAccessor)Minecraft.m_91087_().f_91061_;
        return particleEngine.getTrackedParticleCounts().getInt((Object)particleGroup);
    }

    private static void spawnParticles(ClientLevel level, Holder<Biome> biome, double x, double y, double z) {
        Biome.Precipitation precipitation = StonecutterUtil.getPrecipitationAt((Level)level, (Biome)biome.m_203334_(), (BlockPos)(ModConfig.CONFIG.compat.useHeightmapTemp ? heightmapPos : pos));
        block12: for (ModConfig.ParticleOptions opts : ModConfig.CONFIG.customParticles) {
            if (!opts.enabled || !opts.precipitation.contains(precipitation) || !(opts.density > level.f_46441_.m_188501_()) || !WeatherParticleManager.meetsRequirements(opts.biomeList, opts.biomeWhitelist, Registries.f_256952_, biome) || !WeatherParticleManager.meetsRequirements(opts.blockList, opts.blockWhitelist, Registries.f_256747_, level.m_8055_((BlockPos)heightmapPos).m_222976_())) continue;
            if (opts.onGround) {
                double localBlockX = x - (double)pos.m_123341_();
                double localBlockZ = z - (double)pos.m_123343_();
                BlockState blockState = level.m_8055_((BlockPos)heightmapPos);
                FluidState fluidState = level.m_6425_((BlockPos)heightmapPos);
                VoxelShape voxelShape = blockState.m_60812_((BlockGetter)level, (BlockPos)heightmapPos);
                double blockHeight = voxelShape.m_83290_(Direction.Axis.Y, localBlockX, localBlockZ);
                double fluidHeight = fluidState.m_76155_((BlockGetter)level, (BlockPos)heightmapPos);
                y = (double)heightmapPos.m_123342_() + Math.max(blockHeight, fluidHeight);
            }
            switch (opts.id) {
                case "rain_splashing": {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123761_, x, y, z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case "rain_ripples": {
                    level.m_7106_((ParticleOptions)ParticleRain.RIPPLE, x, y, z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case "rain_smoke": {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case "shrubs": {
                    level.m_7106_((ParticleOptions)ParticleRain.SHRUB, x, y, z, 0.0, 0.0, 0.0);
                    continue block12;
                }
            }
            Minecraft.m_91087_().f_91061_.m_107344_((Particle)new CustomParticle(level, x, y, z, opts));
        }
    }

    public static <T> boolean meetsRequirements(List<String> list, boolean isWhitelist, ResourceKey<? extends Registry<T>> registry, Holder<T> holder) {
        if (!list.isEmpty()) {
            for (String string : list) {
                boolean hasMatch;
                ResourceLocation location = StonecutterUtil.parseResourceLocation(string);
                if (location == null) continue;
                TagKey tag = TagKey.m_203882_(registry, (ResourceLocation)location);
                boolean bl = hasMatch = holder.m_203373_(location) || holder.m_203656_(tag);
                if (isWhitelist && hasMatch) {
                    return true;
                }
                if (!hasMatch) continue;
                return false;
            }
            return !isWhitelist;
        }
        return true;
    }

    public static void tick(ClientLevel level, Vec3 cameraPos) {
        ParticleEngineAccessor particleEngine = (ParticleEngineAccessor)Minecraft.m_91087_().f_91061_;
        if (level.m_46471_() && particleEngine.callHasSpaceInParticleLimit(particleGroup)) {
            int density = (int)((float)Mth.m_269140_((float)level.m_46661_(1.0f), (int)ModConfig.CONFIG.perf.particleDensity, (int)ModConfig.CONFIG.perf.particleStormDensity) * level.m_46722_(1.0f));
            float speed = (float)Minecraft.m_91087_().m_91288_().m_20184_().m_82556_();
            density *= (int)(speed * 2.0f + 1.0f);
            for (int i = 0; i < density; ++i) {
                int cloudHeight;
                float height;
                if ((double)speed < 0.8) {
                    height = Mth.m_14154_((float)(Mth.m_14207_((float)level.f_46441_.m_188501_()) - Mth.m_14207_((float)level.f_46441_.m_188501_()))) * -1.0f + 1.0f;
                    height *= 1.0f;
                } else {
                    height = level.f_46441_.m_188501_();
                }
                float theta = (float)Math.PI * 2 * level.f_46441_.m_188501_();
                float phi = (float)Math.acos(2.0f * height - 1.0f);
                float x = (float)ModConfig.CONFIG.perf.particleDistance * Mth.m_14031_((float)phi) * Mth.m_14089_((float)theta) + (float)cameraPos.f_82479_;
                float y = (float)ModConfig.CONFIG.perf.particleDistance * Mth.m_14089_((float)phi) + (float)cameraPos.f_82480_;
                float z = (float)ModConfig.CONFIG.perf.particleDistance * Mth.m_14031_((float)phi) * Mth.m_14031_((float)theta) + (float)cameraPos.f_82481_;
                if (!ModConfig.CONFIG.compat.canSpawnAboveClouds && (cloudHeight = StonecutterUtil.getCloudHeight(level)) != 0 && y > (float)cloudHeight) {
                    y = cloudHeight;
                }
                pos.m_122169_((double)x, (double)y, (double)z);
                heightmapPos.m_122169_((double)x, (double)(level.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_()) - 1), (double)z);
                if (heightmapPos.m_123342_() > pos.m_123342_()) continue;
                WeatherParticleManager.spawnParticles(level, (Holder<Biome>)level.m_204166_((BlockPos)pos), x, y, z);
            }
        }
    }

    public static SoundEvent getAdditionalWeatherSounds(ClientLevel level, BlockPos blockPos, boolean above) {
        Holder biome = level.m_204166_(blockPos);
        Biome.Precipitation precipitation = StonecutterUtil.getPrecipitationAt((Level)level, (Biome)biome.m_203334_(), blockPos);
        if (precipitation == Biome.Precipitation.SNOW && ModConfig.CONFIG.sound.doSnowSounds) {
            return above ? ParticleRain.WEATHER_SNOW_ABOVE : ParticleRain.WEATHER_SNOW;
        }
        if (WeatherParticleManager.doesThisBlockHaveDustBlowing(precipitation, level, blockPos, (Holder<Biome>)biome) && ModConfig.CONFIG.sound.doWindSounds) {
            return above ? ParticleRain.WEATHER_SANDSTORM_ABOVE : ParticleRain.WEATHER_SANDSTORM;
        }
        return null;
    }

    public static boolean doesThisBlockHaveDustBlowing(Biome.Precipitation precipitation, ClientLevel level, BlockPos blockPos, Holder<Biome> biome) {
        boolean matchesTag = false;
        List<String> dustyBlockTags = List.of("minecraft:camel_sand_step_sound_blocks", "minecraft:sand");
        for (int i = 0; i < dustyBlockTags.size(); ++i) {
            if (!level.m_8055_(level.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockPos).m_7495_()).m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)StonecutterUtil.parseResourceLocation(dustyBlockTags.get(i))))) continue;
            matchesTag = true;
            break;
        }
        return precipitation == Biome.Precipitation.NONE && matchesTag && (double)((Biome)biome.m_203334_()).m_47554_() > 0.25;
    }

    public static boolean canHostStreaks(BlockState state) {
        return state.m_204336_(BlockTags.f_13049_) || state.m_204336_(BlockTags.f_144282_) || state.m_204336_(ParticleRain.GLASS_PANES);
    }

    static {
        pos = new BlockPos.MutableBlockPos();
        heightmapPos = new BlockPos.MutableBlockPos();
    }
}

