/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.forge.platform;

import dev.architectury.utils.Env;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import me.pandamods.pandalib.networking.NetworkContext;
import me.pandamods.pandalib.networking.NetworkReceiver;
import me.pandamods.pandalib.platform.services.NetworkHelper;
import me.pandamods.pandalib.utils.EnvRunner;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHelperImpl
implements NetworkHelper {
    public static final Map<ResourceLocation, SimpleChannel> CHANNELS = new HashMap<ResourceLocation, SimpleChannel>();
    private int id = 0;

    @Override
    public void registerClientReceiver(ResourceLocation resourceLocation, NetworkReceiver receiver) {
        EnvRunner.runIf(Env.CLIENT, () -> () -> this.registerChannel(resourceLocation, receiver));
    }

    @Override
    public void registerServerReceiver(ResourceLocation resourceLocation, NetworkReceiver receiver) {
        this.registerChannel(resourceLocation, receiver);
    }

    @Override
    public void registerBiDirectionalReceiver(ResourceLocation resourceLocation, NetworkReceiver clientReceiver, NetworkReceiver serverReceiver) {
        this.registerChannel(resourceLocation, (ctx, byteBuf) -> {
            switch (ctx.getDirection()) {
                case CLIENT: {
                    clientReceiver.receive(ctx, byteBuf);
                    break;
                }
                case SERVER: {
                    serverReceiver.receive(ctx, byteBuf);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(ctx.getDirection()));
                }
            }
        });
    }

    private void registerChannel(ResourceLocation resourceLocation, NetworkReceiver receiver) {
        if (CHANNELS.containsKey(resourceLocation)) {
            throw new IllegalArgumentException(String.format("Networking channel '%s' has already been registered", resourceLocation));
        }
        SimpleChannel channel = NetworkRegistry.newSimpleChannel((ResourceLocation)resourceLocation, () -> "1", s -> true, s -> true);
        channel.registerMessage(this.id++, FriendlyByteBuf.class, (o, byteBuf) -> byteBuf.writeBytes((ByteBuf)o), byteBuf -> byteBuf, (o, contextSupplier) -> {
            ServerPlayer serverPlayer = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            receiver.receive(new NetworkContext((Player)serverPlayer, switch (((NetworkEvent.Context)contextSupplier.get()).getDirection()) {
                default -> throw new IncompatibleClassChangeError();
                case NetworkDirection.PLAY_TO_CLIENT, NetworkDirection.LOGIN_TO_CLIENT -> Env.CLIENT;
                case NetworkDirection.PLAY_TO_SERVER, NetworkDirection.LOGIN_TO_SERVER -> Env.SERVER;
            }), (FriendlyByteBuf)o);
        });
        CHANNELS.put(resourceLocation, channel);
    }

    @Override
    public void sendToServer(ResourceLocation resourceLocation, FriendlyByteBuf byteBuf) {
        CHANNELS.get(resourceLocation).sendToServer((Object)byteBuf);
    }

    @Override
    public void sendToPlayer(ServerPlayer player, ResourceLocation resourceLocation, FriendlyByteBuf byteBuf) {
        CHANNELS.get(resourceLocation).send(PacketDistributor.PLAYER.with(() -> player), (Object)byteBuf);
    }

    @Override
    public void sendToAllPlayers(ResourceLocation resourceLocation, FriendlyByteBuf byteBuf) {
        CHANNELS.get(resourceLocation).send(PacketDistributor.ALL.noArg(), (Object)byteBuf);
    }
}

