/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.numismaticsutils.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class NumismaticsConfigClient {
    public static final ForgeConfigSpec CLIENT_SPEC;
    private static ForgeConfigSpec.ConfigValue<Integer> hudX;
    private static ForgeConfigSpec.ConfigValue<Integer> hudY;
    private static ForgeConfigSpec.ConfigValue<Double> hudScale;

    private NumismaticsConfigClient() {
    }

    private static void setupConfig(ForgeConfigSpec.Builder builder) {
        builder.push("Numismatics Utils");
        hudX = builder.comment("The horizontal offset of the Bank Meter text (in pixels)\nDefault is 2.").define("hud_x_position", (Object)2);
        hudY = builder.comment("The vertical offset of the Bank Meter text (in pixels)\nDefault is 2.").define("hud_y_position", (Object)2);
        hudScale = builder.comment("The scale of the Bank Meter text.\nDefault is 1.0.").defineInRange("hud_scale", 1.0, 0.5, 10.0);
    }

    private static <T> T getOrDefault(ForgeConfigSpec.ConfigValue<T> config) {
        if (CLIENT_SPEC.isLoaded()) {
            return (T)config.get();
        }
        return (T)config.getDefault();
    }

    public static int getHudX() {
        return NumismaticsConfigClient.getOrDefault(hudX);
    }

    public static void setHudX(int x) {
        hudX.set((Object)x);
    }

    public static int getHudY() {
        return NumismaticsConfigClient.getOrDefault(hudY);
    }

    public static void setHudY(int y) {
        hudY.set((Object)y);
    }

    public static double getHudScale() {
        return NumismaticsConfigClient.getOrDefault(hudScale);
    }

    public static void setHudScale(double scale) {
        hudScale.set((Object)scale);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        NumismaticsConfigClient.setupConfig(builder);
        CLIENT_SPEC = builder.build();
    }
}

