/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.client;

import com.alc.moreminecarts.client.MMButton;
import com.alc.moreminecarts.containers.MinecartUnLoaderContainer;
import com.alc.moreminecarts.proxy.MoreMinecartsPacketHandler;
import com.alc.moreminecarts.tile_entities.AbstractCommonLoader;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class MinecartUnLoaderScreen
extends AbstractContainerScreen<MinecartUnLoaderContainer> {
    private static final ResourceLocation display = new ResourceLocation("moreminecarts:textures/gui/loader_gui.png");
    private final List<AbstractButton> buttons = Lists.newArrayList();

    public MinecartUnLoaderScreen(MinecartUnLoaderContainer container, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)container, inv, (Component)Component.m_237115_((String)(container.getIsUnloader() ? "Minecart Unloader" : "Minecart Loader")));
    }

    public Component m_96636_() {
        return Component.m_237115_((String)(((MinecartUnLoaderContainer)this.f_97732_).getIsUnloader() ? "Minecart Unloader" : "Minecart Loader"));
    }

    private void addButton(AbstractButton p_169617_) {
        this.m_142416_((GuiEventListener)p_169617_);
        this.buttons.add(p_169617_);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.addButton(new OutputTypeButton(this.f_97735_ + 46, this.f_97736_ + 19));
        this.addButton(new OnlyLockedButton(this.f_97735_ + 68, this.f_97736_ + 19));
        this.addButton(new ComparatorOutputButton(this.f_97735_ + 90, this.f_97736_ + 19));
        this.addButton(new LeaveOneInStackButton(this.f_97735_ + 112, this.f_97736_ + 19));
    }

    public void m_88315_(GuiGraphics p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        this.m_280273_(p_230430_1_);
        super.m_88315_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        for (AbstractButton button : this.buttons) {
            button.m_88315_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        }
        this.m_280072_(p_230430_1_, p_230430_2_, p_230430_3_);
    }

    protected void m_7286_(GuiGraphics matrix, float p_230450_2_, int p_230450_3_, int p_230450_4_) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)display);
        matrix.m_280218_(display, this.f_97735_, this.f_97736_, 0, 0, 176, 166);
        Object contents_text = "";
        FluidStack fluid_stack = ((MinecartUnLoaderContainer)this.f_97732_).getFluids();
        contents_text = fluid_stack == null || fluid_stack.isEmpty() ? (String)contents_text + "0/2,000 mB fluid, " : (String)contents_text + fluid_stack.getAmount() + "/2,000 mB " + fluid_stack.getDisplayName().getString() + ", ";
        int energy_amount = ((MinecartUnLoaderContainer)this.f_97732_).getEnergy();
        contents_text = (String)contents_text + energy_amount + "/2,000 RF";
        matrix.m_280056_(this.f_96547_, (String)contents_text, this.f_97735_ + 7, this.f_97736_ + 62, 0x404040, false);
    }

    protected void m_280003_(GuiGraphics matrix, int p_230451_2_, int p_230451_3_) {
        matrix.m_280614_(this.f_96547_, this.m_96636_(), this.f_97728_, this.f_97729_, 0x404040, false);
        matrix.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    class OutputTypeButton
    extends MMButton {
        boolean oldValue;

        protected OutputTypeButton(int x, int y) {
            super(x, y);
            this.UpdateTooltip();
        }

        public void m_87963_(GuiGraphics matrix, int x, int y, float p_230431_4_) {
            boolean mouse_on;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)display);
            boolean bl = mouse_on = MinecartUnLoaderScreen.this.m_7282_() && this.f_93622_;
            if (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getRedstoneOutput()) {
                if (mouse_on) {
                    matrix.m_280218_(display, this.xPos, this.yPos, 230, 36, 18, 18);
                } else {
                    matrix.m_280218_(display, this.xPos, this.yPos, 212, 36, 18, 18);
                }
            } else if (mouse_on) {
                matrix.m_280218_(display, this.xPos, this.yPos, 230, 18, 18, 18);
            }
            boolean newValue = ((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getRedstoneOutput();
            if (newValue != this.oldValue) {
                this.oldValue = newValue;
                this.UpdateTooltip();
            }
        }

        @Override
        public void m_5691_() {
            MoreMinecartsPacketHandler.MinecartLoaderPacket packet = ((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getCurrentPacket();
            packet.redstone_output = !packet.redstone_output;
            MoreMinecartsPacketHandler.INSTANCE.sendToServer((Object)packet);
        }

        @Override
        protected void m_168797_(NarrationElementOutput p_259858_) {
        }

        public void UpdateTooltip() {
            this.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)(((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getRedstoneOutput() ? "Output redstone activation" : "Output to comparator"))));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class OnlyLockedButton
    extends MMButton {
        boolean oldValue;

        protected OnlyLockedButton(int x, int y) {
            super(x, y);
            this.UpdateTooltip();
        }

        public void m_87963_(GuiGraphics matrix, int x, int y, float p_230431_4_) {
            boolean mouse_on;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)display);
            boolean bl = mouse_on = MinecartUnLoaderScreen.this.m_7282_() && this.f_93622_;
            if (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getLockedMinecartsOnly()) {
                if (mouse_on) {
                    if (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getIsUnloader()) {
                        matrix.m_280218_(display, this.xPos, this.yPos, 230, 108, 18, 18);
                    } else {
                        matrix.m_280218_(display, this.xPos, this.yPos, 194, 108, 18, 18);
                    }
                } else if (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getIsUnloader()) {
                    matrix.m_280218_(display, this.xPos, this.yPos, 212, 108, 18, 18);
                } else {
                    matrix.m_280218_(display, this.xPos, this.yPos, 176, 108, 18, 18);
                }
            } else if (mouse_on) {
                matrix.m_280218_(display, this.xPos, this.yPos, 194, 90, 18, 18);
            }
            boolean newValue = ((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getLockedMinecartsOnly();
            if (newValue != this.oldValue) {
                this.oldValue = newValue;
                this.UpdateTooltip();
            }
        }

        @Override
        public void m_5691_() {
            MoreMinecartsPacketHandler.MinecartLoaderPacket packet = ((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getCurrentPacket();
            packet.locked_minecarts_only = !packet.locked_minecarts_only;
            MoreMinecartsPacketHandler.INSTANCE.sendToServer((Object)packet);
        }

        @Override
        protected void m_168797_(NarrationElementOutput p_259858_) {
        }

        public void UpdateTooltip() {
            this.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)(((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getLockedMinecartsOnly() ? "Consider only locked minecarts" : "Consider all minecarts"))));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class ComparatorOutputButton
    extends MMButton {
        AbstractCommonLoader.ComparatorOutputType oldValue;

        protected ComparatorOutputButton(int x, int y) {
            super(x, y);
            this.UpdateTooltip();
        }

        public void m_87963_(GuiGraphics matrix, int x, int y, float p_230431_4_) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)display);
            boolean mouse_on = MinecartUnLoaderScreen.this.m_7282_() && this.f_93622_;
            switch (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getComparatorOutputType()) {
                case done_loading: {
                    if (mouse_on) {
                        matrix.m_280218_(display, this.xPos, this.yPos, 194, 18, 18, 18);
                        break;
                    }
                    matrix.m_280218_(display, this.xPos, this.yPos, 176, 18, 18, 18);
                    break;
                }
                case cart_full: {
                    if (mouse_on) {
                        if (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getIsUnloader()) {
                            matrix.m_280218_(display, this.xPos, this.yPos, 230, 0, 18, 18);
                            break;
                        }
                        matrix.m_280218_(display, this.xPos, this.yPos, 194, 0, 18, 18);
                        break;
                    }
                    if (!((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getIsUnloader()) break;
                    matrix.m_280218_(display, this.xPos, this.yPos, 212, 0, 18, 18);
                    break;
                }
                case cart_fullness: {
                    if (mouse_on) {
                        matrix.m_280218_(display, this.xPos, this.yPos, 194, 36, 18, 18);
                        break;
                    }
                    matrix.m_280218_(display, this.xPos, this.yPos, 176, 36, 18, 18);
                    break;
                }
            }
            AbstractCommonLoader.ComparatorOutputType newValue = ((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getComparatorOutputType();
            if (newValue != this.oldValue) {
                this.oldValue = newValue;
                this.UpdateTooltip();
            }
        }

        @Override
        public void m_5691_() {
            MoreMinecartsPacketHandler.MinecartLoaderPacket packet = ((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getCurrentPacket();
            packet.output_type = AbstractCommonLoader.ComparatorOutputType.next(packet.output_type);
            MoreMinecartsPacketHandler.INSTANCE.sendToServer((Object)packet);
        }

        @Override
        protected void m_168797_(NarrationElementOutput p_259858_) {
        }

        public void UpdateTooltip() {
            this.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)(switch (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getComparatorOutputType()) {
                case AbstractCommonLoader.ComparatorOutputType.done_loading -> "Activate output during loading inactivity";
                case AbstractCommonLoader.ComparatorOutputType.cart_full -> {
                    if (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getIsUnloader()) {
                        yield "Activate output when cart is empty";
                    }
                    yield "Activate output when cart is full";
                }
                case AbstractCommonLoader.ComparatorOutputType.cart_fullness -> "Output cart contents";
                default -> "ERROR";
            }))));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class LeaveOneInStackButton
    extends MMButton {
        boolean oldValue;

        protected LeaveOneInStackButton(int x, int y) {
            super(x, y);
            this.UpdateTooltip();
        }

        public void m_87963_(GuiGraphics matrix, int x, int y, float p_230431_4_) {
            boolean mouse_on;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)display);
            boolean bl = mouse_on = MinecartUnLoaderScreen.this.m_7282_() && this.f_93622_;
            if (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getLeaveOneInStack()) {
                if (mouse_on) {
                    if (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getIsUnloader()) {
                        matrix.m_280218_(display, this.xPos, this.yPos, 230, 72, 18, 18);
                    } else {
                        matrix.m_280218_(display, this.xPos, this.yPos, 194, 72, 18, 18);
                    }
                } else if (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getIsUnloader()) {
                    matrix.m_280218_(display, this.xPos, this.yPos, 212, 72, 18, 18);
                } else {
                    matrix.m_280218_(display, this.xPos, this.yPos, 176, 72, 18, 18);
                }
            } else if (mouse_on) {
                matrix.m_280218_(display, this.xPos, this.yPos, 194, 54, 18, 18);
            }
            boolean newValue = ((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getLeaveOneInStack();
            if (newValue != this.oldValue) {
                this.oldValue = newValue;
                this.UpdateTooltip();
            }
        }

        @Override
        public void m_5691_() {
            MoreMinecartsPacketHandler.MinecartLoaderPacket packet = ((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getCurrentPacket();
            packet.leave_one_item_in_stack = !packet.leave_one_item_in_stack;
            MoreMinecartsPacketHandler.INSTANCE.sendToServer((Object)packet);
        }

        @Override
        protected void m_168797_(NarrationElementOutput p_259858_) {
        }

        public void UpdateTooltip() {
            this.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)(((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getIsUnloader() ? (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getLeaveOneInStack() ? "Leave one item in minecart slots" : "Empty minecart slots entirely") : (((MinecartUnLoaderContainer)MinecartUnLoaderScreen.this.f_97732_).getLeaveOneInStack() ? "Leave one item in loader slots" : "Empty loader slots entirely")))));
        }
    }
}

