/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.client;

import com.alc.moreminecarts.client.MMButton;
import com.alc.moreminecarts.containers.ChunkLoaderContainer;
import com.alc.moreminecarts.proxy.MoreMinecartsPacketHandler;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChunkLoaderScreen
extends AbstractContainerScreen<ChunkLoaderContainer> {
    private static final ResourceLocation display = new ResourceLocation("moreminecarts:textures/gui/chunk_loader_gui.png");
    private final List<AbstractButton> buttons = Lists.newArrayList();

    public ChunkLoaderScreen(ChunkLoaderContainer container, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)container, inv, (Component)Component.m_237115_((String)"Chunk Loader"));
    }

    private void addButton(AbstractButton p_169617_) {
        this.m_142416_((GuiEventListener)p_169617_);
        this.buttons.add(p_169617_);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.addButton(new ChunkLoaderButton(this.f_97735_ + 131, this.f_97736_ + 14));
    }

    public void m_88315_(GuiGraphics p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        this.m_280273_(p_230430_1_);
        super.m_88315_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        for (AbstractButton button : this.buttons) {
            button.m_88315_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        }
        this.m_280072_(p_230430_1_, p_230430_2_, p_230430_3_);
    }

    protected void m_7286_(GuiGraphics matrix, float p_230450_2_, int p_230450_3_, int p_230450_4_) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)display);
        matrix.m_280218_(display, this.f_97735_, this.f_97736_, 0, 0, 176, 166);
        double log_progress = ((ChunkLoaderContainer)this.f_97732_).getLogProgress();
        int progess = (int)Math.ceil(120.0 * log_progress);
        matrix.m_280218_(display, this.f_97735_ + 28, this.f_97736_ + 36, 0, 166, progess, 16);
        int minutes_left = ((ChunkLoaderContainer)this.f_97732_).getTimeLeft();
        matrix.m_280056_(this.f_96547_, minutes_left + " minutes left", this.f_97735_ + 29, this.f_97736_ + 55, 0x404040, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    class ChunkLoaderButton
    extends MMButton {
        boolean oldValue;

        protected ChunkLoaderButton(int x, int y) {
            super(x, y);
            this.UpdateTooltip();
        }

        public void m_87963_(GuiGraphics matrix, int x, int y, float p_230431_4_) {
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)display);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (((ChunkLoaderContainer)ChunkLoaderScreen.this.f_97732_).isEnabled()) {
                if (this.f_93622_) {
                    matrix.m_280218_(display, this.xPos, this.yPos, 194, 18, 18, 18);
                } else {
                    matrix.m_280218_(display, this.xPos, this.yPos, 176, 18, 18, 18);
                }
            } else if (this.f_93622_) {
                matrix.m_280218_(display, this.xPos, this.yPos, 176, 0, 18, 18);
            }
            boolean newValue = ((ChunkLoaderContainer)ChunkLoaderScreen.this.f_97732_).isEnabled();
            if (newValue != this.oldValue) {
                this.oldValue = newValue;
                this.UpdateTooltip();
            }
        }

        @Override
        public void m_5691_() {
            MoreMinecartsPacketHandler.ChunkLoaderPacket packet = new MoreMinecartsPacketHandler.ChunkLoaderPacket(!((ChunkLoaderContainer)ChunkLoaderScreen.this.f_97732_).isEnabled());
            MoreMinecartsPacketHandler.INSTANCE.sendToServer((Object)packet);
        }

        @Override
        protected void m_168797_(NarrationElementOutput p_259858_) {
        }

        public void UpdateTooltip() {
            this.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)(((ChunkLoaderContainer)ChunkLoaderScreen.this.f_97732_).isEnabled() ? "On" : "Off"))));
        }
    }
}

