/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.entity;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.littlejoys.entity.ModEntities;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class DropRushItemEntity
extends ItemEntity {
    private int ticksPassed;
    private int actualLifetime = 6000;
    private boolean pickedUp;
    private static final EntityDataAccessor<Optional<UUID>> DATA_TARGET = SynchedEntityData.m_135353_(DropRushItemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public DropRushItemEntity(EntityType<? extends ItemEntity> entityType, Level level) {
        super(entityType, level);
    }

    public DropRushItemEntity(Level level, double posX, double posY, double posZ, ItemStack itemStack, double deltaX, double deltaY, double deltaZ) {
        this((EntityType<? extends ItemEntity>)((EntityType)ModEntities.dropRushItem.get()), level);
        this.m_6034_(posX, posY, posZ);
        this.m_20334_(deltaX, deltaY, deltaZ);
        this.m_32045_(itemStack);
    }

    public DropRushItemEntity(DropRushItemEntity other) {
        super(other.m_6095_(), other.m_9236_());
        this.m_32045_(other.m_32055_().m_41777_());
        this.m_20359_((Entity)other);
        this.ticksPassed = other.ticksPassed;
        this.actualLifetime = other.actualLifetime;
        this.pickedUp = other.pickedUp;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.ticksPassed;
        if (this.ticksPassed >= this.actualLifetime) {
            this.m_146870_();
        }
        if (this.m_9236_().f_46443_ && !this.m_20096_()) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123751_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public void m_142036_() {
        super.m_142036_();
        if (this.pickedUp) {
            this.m_9236_().m_7107_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 0.0, 0.0, 0.0);
        } else {
            this.m_9236_().m_7107_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 0.0, 0.0, 0.0);
            this.m_9236_().m_7107_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public void setActualLifetime(int actualLifetime) {
        this.actualLifetime = actualLifetime;
    }

    public boolean isPickedUp() {
        return this.pickedUp;
    }

    public void setPickedUp(boolean pickedUp) {
        this.pickedUp = pickedUp;
    }

    public void m_266426_(@Nullable UUID target) {
        super.m_266426_(target);
        this.m_20088_().m_135381_(DATA_TARGET, Optional.ofNullable(target));
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (key == DATA_TARGET) {
            ((Optional)this.m_20088_().m_135370_(DATA_TARGET)).ifPresent(this::m_266426_);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_TARGET, Optional.empty());
    }

    public boolean m_142038_() {
        Player player = Balm.getProxy().getClientPlayer();
        return player != null && Objects.equals(this.getTarget(), player.m_20148_());
    }

    public int m_19876_() {
        return ChatFormatting.RED.m_126665_();
    }

    @Nullable
    public UUID getTarget() {
        return ((Optional)this.m_20088_().m_135370_(DATA_TARGET)).orElse(null);
    }

    public ItemEntity m_32066_() {
        return new DropRushItemEntity(this);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        if (reason == Entity.RemovalReason.DISCARDED && this.m_32055_().m_41619_()) {
            this.setPickedUp(true);
        }
    }
}

