/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.util.contract;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.satisfy.wildernature.util.BountyBoardTier;
import net.satisfy.wildernature.util.contract.Contract;

public class ContractReloader
implements ResourceManagerReloadListener {
    private static final HashMap<ResourceLocation, Contract> contracts = new HashMap();
    public static final HashMap<ResourceLocation, BountyBoardTier> tiers = new HashMap();

    public static Contract getContract(ResourceLocation location) {
        String path = location.m_135815_();
        int index = path.indexOf("/");
        String newLocation = path.substring(index + 1);
        ResourceLocation rl = new ResourceLocation(location.m_135827_(), newLocation);
        return contracts.get(rl);
    }

    public static List<ResourceLocation> getContractsOfTier(ResourceLocation tierId) {
        return contracts.keySet().stream().filter(key -> {
            ArrayList<ResourceLocation> allTiers = new ArrayList<ResourceLocation>();
            ResourceLocation id = tierId;
            while (true) {
                allTiers.add(id);
                ResourceLocation idCopy = id;
                BountyBoardTier tier = BountyBoardTier.byId(id).orElseThrow(() -> new RuntimeException("Error: Not found tier with id %s".formatted(idCopy)));
                if (!tier.previousTier().isPresent()) break;
                id = tier.previousTier().get();
            }
            return allTiers.contains(contracts.get(key).tier());
        }).toList();
    }

    public static ResourceLocation getRandomContractOfTier(ResourceLocation tier) {
        List<ResourceLocation> contractsOfTier = ContractReloader.getContractsOfTier(tier);
        if (contractsOfTier.isEmpty()) {
            throw new RuntimeException("No contracts available for tier: " + tier);
        }
        return contractsOfTier.get(new Random().nextInt(contractsOfTier.size()));
    }

    public void m_6213_(ResourceManager manager) {
        contracts.clear();
        Map contractResources = manager.m_214159_("wildernature_contracts", path -> path.m_135815_().endsWith(".json"));
        contractResources.forEach((resourceLocation, resource) -> {
            try (InputStream open = resource.m_215507_();){
                int index = resourceLocation.m_135815_().indexOf("/");
                String pathEdits = resourceLocation.m_135815_().substring(index + 1);
                String jsonString = new String(open.readAllBytes(), StandardCharsets.UTF_8);
                Contract contract = (Contract)Contract.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)new Gson().fromJson(jsonString, JsonElement.class))).getOrThrow(false, error -> {
                    throw new RuntimeException("Failed to parse contract: " + error);
                });
                ResourceLocation rl = new ResourceLocation(resourceLocation.m_135827_(), pathEdits);
                contracts.put(rl, contract);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load contract: " + resourceLocation, e);
            }
        });
        tiers.clear();
        Map tierResources = manager.m_214159_("wildernature_tiers", path -> path.m_135815_().endsWith(".json"));
        tierResources.forEach((resourceLocation, resource) -> {
            try (InputStream open = resource.m_215507_();){
                String namespace = resourceLocation.m_135827_();
                String pathEdits = resourceLocation.m_135815_().substring("wildernature_tiers/".length(), resourceLocation.m_135815_().length() - ".json".length());
                String jsonString = new String(open.readAllBytes(), StandardCharsets.UTF_8);
                BountyBoardTier tier = (BountyBoardTier)BountyBoardTier.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)new Gson().fromJson(jsonString, JsonElement.class))).getOrThrow(false, error -> {
                    throw new RuntimeException("Failed to parse tier: " + error);
                });
                ResourceLocation rl = new ResourceLocation(namespace, pathEdits);
                tiers.put(rl, tier);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load tier: " + resourceLocation, e);
            }
        });
    }
}

