/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BegGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.satisfy.wildernature.entity.ai.AnimationAttackGoal;
import net.satisfy.wildernature.entity.ai.EntityWithAttackAnimation;
import net.satisfy.wildernature.entity.animation.ServerAnimationDurations;
import net.satisfy.wildernature.registry.EntityRegistry;
import net.satisfy.wildernature.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedWolfEntity
extends Wolf
implements EntityWithAttackAnimation {
    public AnimationState attackState = new AnimationState();
    public AnimationState sitAnimationState = new AnimationState();
    int lastTargetTick;
    private static final EntityDataAccessor<Boolean> LEAPING = SynchedEntityData.m_135353_(RedWolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(RedWolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(RedWolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22281_, 3.0);
    }

    public RedWolfEntity(EntityType<? extends Wolf> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public LivingEntity getTarget_() {
        return this.m_5448_();
    }

    @Override
    public double getMeleeAttackRangeSqr_(LivingEntity target) {
        return super.m_142593_(target);
    }

    protected SoundEvent m_7515_() {
        if (this.m_21660_()) {
            return (SoundEvent)SoundRegistry.RED_WOLF_AGGRO.get();
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            return this.m_21824_() && this.m_21223_() < 10.0f ? SoundEvents.f_12625_ : SoundEvents.f_12622_;
        }
        return (SoundEvent)SoundRegistry.RED_WOLF_AMBIENT.get();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5){

            protected boolean m_202729_() {
                return this.f_25684_.m_203117_() || this.f_25684_.m_6060_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal<Llama>((PathfinderMob)this, Llama.class, 24.0f, 1.5, 1.5){

            public boolean m_8036_() {
                if (super.m_8036_() && this.f_25016_ instanceof Llama) {
                    return !RedWolfEntity.this.m_21824_() && this.avoidLlama((Llama)this.f_25016_);
                }
                return false;
            }

            private boolean avoidLlama(Llama llama) {
                return llama.m_30823_() >= RedWolfEntity.this.f_19796_.m_188503_(5);
            }

            public void m_8056_() {
                RedWolfEntity.this.m_6710_(null);
                super.m_8056_();
            }

            public void m_8037_() {
                RedWolfEntity.this.m_6710_(null);
                super.m_8037_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new AnimationAttackGoal(this, 1.0, true, (int)(ServerAnimationDurations.red_wolf_attack * 20.0f), 4));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new BegGoal((Wolf)this, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((RedWolfEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, f_30357_));
        this.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Turtle.class, false, Turtle.f_30122_));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            ++this.lastTargetTick;
            if (this.m_5448_() != null) {
                this.lastTargetTick = 0;
            }
            this.setSneaking(this.lastTargetTick < 10);
        }
        if (this.m_9236_().m_5776_()) {
            this.attackState.m_246184_(this.isAttacking(), this.f_19797_);
            this.sitAnimationState.m_246184_(this.isSitting(), this.f_19797_);
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        this.sitAnimationState.m_246184_(this.isSitting(), this.f_19797_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LEAPING, (Object)false);
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(SITTING, (Object)false);
    }

    private void setSneaking(boolean b) {
        this.f_19804_.m_135381_(LEAPING, (Object)b);
    }

    public boolean isSneaking() {
        return (Boolean)this.f_19804_.m_135370_(LEAPING);
    }

    @Nullable
    public RedWolfEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (RedWolfEntity)((EntityType)EntityRegistry.RED_WOLF.get()).m_20615_((Level)serverLevel);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.RED_WOLF_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.RED_WOLF_DEATH.get();
    }

    protected float m_6121_() {
        return 0.3f;
    }

    public int m_8132_() {
        return this.m_21825_() ? 16 : super.m_8132_();
    }

    public float m_30427_() {
        if (this.m_21660_()) {
            return 1.5393804f;
        }
        return this.m_21824_() ? (0.55f - (this.m_21233_() - this.m_21223_()) * 0.02f) * (float)Math.PI : 0.62831855f;
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    @Override
    public void setAttacking_(boolean b) {
        this.f_19804_.m_135381_(ATTACKING, (Object)b);
    }

    @Override
    public Vec3 getPosition_(int i) {
        return super.m_20318_((float)i);
    }

    @Override
    public void doHurtTarget_(LivingEntity targetEntity) {
        super.m_7327_((Entity)targetEntity);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    public void setSitting(boolean sitting) {
        this.f_19804_.m_135381_(SITTING, (Object)sitting);
    }

    public boolean m_21827_() {
        return this.isSitting();
    }

    public void m_21839_(boolean sitting) {
        this.setSitting(sitting);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Sitting", this.isSitting());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        boolean sitting = compound.m_128471_("Sitting");
        this.setSitting(sitting);
    }

    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.m_9236_().m_5776_()) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21830_((LivingEntity)player)) {
            this.setSitting(!this.isSitting());
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }
}

