/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.satisfy.wildernature.item.AmmunitionItem;
import net.satisfy.wildernature.network.EntityPacketHandler;
import net.satisfy.wildernature.registry.EntityRegistry;
import org.jetbrains.annotations.NotNull;

public class BulletEntity
extends Fireball {
    private static final double STOP_TRESHOLD = 0.01;
    private static final double GRAVITY = 0.05;
    private double damage = 1.0;
    private boolean ignoreInvulnerability = false;
    private double knockbackStrength = 0.0;
    private int ticksSinceFired;
    private Vec3 initialPosition;

    public BulletEntity(EntityType<? extends Fireball> entityType, Level level) {
        super(entityType, level);
    }

    public BulletEntity(Level worldIn, LivingEntity shooter) {
        this(worldIn, shooter, 0.0, 0.0, 0.0);
        this.m_6034_(shooter.m_20185_(), shooter.m_20188_() - 0.1, shooter.m_20189_());
        this.initialPosition = new Vec3(shooter.m_20185_(), shooter.m_20188_() - 0.1, shooter.m_20189_());
    }

    public BulletEntity(Level worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super((EntityType)EntityRegistry.BULLET.get(), shooter, accelX, accelY, accelZ, worldIn);
        this.initialPosition = new Vec3(shooter.m_20185_(), shooter.m_20188_() - 0.1, shooter.m_20189_());
    }

    public void m_8119_() {
        double distanceTraveled;
        if (this.initialPosition == null) {
            this.initialPosition = this.m_20182_();
        }
        ++this.ticksSinceFired;
        if (this.ticksSinceFired > 100 || this.m_20184_().m_82556_() < 0.01) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if ((distanceTraveled = this.m_20182_().m_82554_(this.initialPosition)) > 20.0) {
            Vec3 movement = this.m_20184_();
            this.m_20256_(movement.m_82520_(0.0, -0.05, 0.0));
        }
        super.m_8119_();
    }

    protected void m_5790_(EntityHitResult raytrace) {
        super.m_5790_(raytrace);
        if (!this.m_9236_().f_46443_) {
            boolean damaged;
            Entity target = raytrace.m_82443_();
            Entity shooter = this.m_19749_();
            AmmunitionItem bullet = (AmmunitionItem)this.m_37018_().m_41720_();
            int lastHurtResistant = target.f_19802_;
            if (this.ignoreInvulnerability) {
                target.f_19802_ = 0;
            }
            if ((damaged = target.m_6469_(this.m_9236_().m_269111_().m_269104_((Entity)this, shooter), (float)bullet.modifyDamage(this.damage, this, target, shooter, this.m_9236_()))) && target instanceof LivingEntity) {
                Vec3 vec;
                LivingEntity livingTarget = (LivingEntity)target;
                if (this.knockbackStrength > 0.0 && (vec = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(this.knockbackStrength)).m_82556_() > 0.0) {
                    livingTarget.m_5997_(vec.f_82479_, 0.1, vec.f_82481_);
                }
                if (shooter instanceof LivingEntity) {
                    this.m_19970_((LivingEntity)shooter, target);
                }
                AmmunitionItem.onLivingEntityHit(livingTarget, shooter, this.m_9236_());
            } else if (!damaged && this.ignoreInvulnerability) {
                target.f_19802_ = lastHurtResistant;
            }
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!(this.m_9236_().f_46443_ || this.f_19794_ && result.m_6662_() == HitResult.Type.BLOCK)) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("tickssincefired", this.ticksSinceFired);
        compound.m_128347_("damage", this.damage);
        if (this.ignoreInvulnerability) {
            compound.m_128379_("ignoreinvulnerability", true);
        }
        if (this.knockbackStrength != 0.0) {
            compound.m_128347_("knockback", this.knockbackStrength);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.ticksSinceFired = compound.m_128451_("tickssincefired");
        this.damage = compound.m_128459_("damage");
        this.ignoreInvulnerability = compound.m_128471_("ignoreinvulnerability");
        this.knockbackStrength = compound.m_128459_("knockback");
    }

    public double getDamage() {
        return this.damage;
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    public void setIgnoreInvulnerability(boolean ignoreInvulnerability) {
        this.ignoreInvulnerability = ignoreInvulnerability;
    }

    public void m_37251_(Entity shooter, float xRot, float yRot, float p_37255_, float speed, float spread) {
        float f = -Mth.m_14031_((float)(yRot * ((float)Math.PI / 180))) * Mth.m_14089_((float)(xRot * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((xRot + p_37255_) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(yRot * ((float)Math.PI / 180))) * Mth.m_14089_((float)(xRot * ((float)Math.PI / 180)));
        this.m_6686_(f, f1, f2, speed, spread);
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    protected float m_6884_() {
        return 1.0f;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return EntityPacketHandler.createAddEntityPacket((Entity)this);
    }
}

