/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WallDecorationBlock
extends HorizontalDirectionalBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final Map<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0)));

    public WallDecorationBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static VoxelShape getBoundingShape(BlockState state) {
        return BOUNDING_SHAPES.get(state.m_61143_((Property)FACING));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return WallDecorationBlock.getBoundingShape(state);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        BlockState blockState = world.m_8055_(blockPos);
        return blockState.m_60783_((BlockGetter)world, blockPos, direction);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction[] var5;
        Level worldView = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        for (Direction direction : var5 = ctx.m_6232_()) {
            BlockState blockState;
            if (!direction.m_122434_().m_122479_() || !(blockState = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction.m_122424_())).m_60710_((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction.m_122424_() == state.m_61143_((Property)FACING) && !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : state;
    }
}

