/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.wildernature.block.WallDecorationBlock;
import net.satisfy.wildernature.registry.TagsRegistry;
import net.satisfy.wildernature.util.WilderNatureUtil;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;

public class RedWolfTrophyBlock
extends WallDecorationBlock {
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.1875, (double)0.9375, (double)1.0, (double)0.8125, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.28125, (double)0.5625, (double)0.75, (double)0.65625, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.5625, (double)0.65625, (double)0.8125, (double)0.75, (double)0.90625, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.65625, (double)0.8125, (double)0.4375, (double)0.90625, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.28125, (double)0.375, (double)0.625, (double)0.46875, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, WilderNatureUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });

    public RedWolfTrophyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)FACING));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_) {
            Vector3d center = new Vector3d((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            double range = 32.0;
            AABB boundingBox = new AABB(center.x - range, center.y - range, center.z - range, center.x + range, center.y + range, center.z + range);
            List<BlockPos> blockPositions = BlockPos.m_121921_((AABB)boundingBox).map(BlockPos::m_7949_).toList();
            for (BlockPos blockPos : blockPositions) {
                BlockState blockState = world.m_8055_(blockPos);
                if (!blockState.m_204336_(TagsRegistry.MAKES_BLOCK_GLOW)) continue;
                AreaEffectCloud effectCloud = new AreaEffectCloud(world, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
                effectCloud.m_19712_(0.5f);
                effectCloud.m_19734_(600);
                effectCloud.m_19740_(0);
                effectCloud.m_19724_((ParticleOptions)ParticleTypes.f_175827_);
                world.m_7967_((Entity)effectCloud);
            }
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }
}

