/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.wildernature.block.entity.CompletionistBannerEntity;
import net.satisfy.wildernature.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionistBannerBlock
extends BaseEntityBlock {
    public static final IntegerProperty ROTATION = BlockStateProperties.f_61390_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public CompletionistBannerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.makeDefaultState();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new CompletionistBannerEntity(blockPos, blockState);
    }

    protected void makeDefaultState() {
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0)));
    }

    public boolean m_7898_(@NotNull BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        BlockState belowBlockState = levelReader.m_8055_(blockPos.m_7495_());
        return belowBlockState.m_280296_();
    }

    public boolean m_48673_(BlockState blockState) {
        return true;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        context.m_8083_();
        Direction clickedFace = context.m_43719_();
        if (clickedFace == Direction.UP || clickedFace == Direction.DOWN) {
            return (BlockState)this.m_49966_().m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(Mth.m_14107_((double)((double)((180.0f + context.m_7074_()) * 16.0f / 360.0f) + 0.5)) & 0xF));
        }
        if (this == ObjectRegistry.WOLF_TRAPPER_BANNER.get()) {
            return (BlockState)((Block)ObjectRegistry.WOLF_TRAPPER_WALL_BANNER.get()).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)clickedFace.m_122424_());
        }
        if (this == ObjectRegistry.BUNNY_STALKER_BANNER.get()) {
            return (BlockState)((Block)ObjectRegistry.BUNNY_STALKER_WALL_BANNER.get()).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)clickedFace.m_122424_());
        }
        if (this == ObjectRegistry.COD_CATCHER_BANNER.get()) {
            return (BlockState)((Block)ObjectRegistry.COD_CATCHER_WALL_BANNER.get()).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)clickedFace.m_122424_());
        }
        return (BlockState)((Block)ObjectRegistry.WOLF_TRAPPER_WALL_BANNER.get()).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)clickedFace.m_122424_());
    }

    @NotNull
    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rotation.m_55949_(((Integer)blockState.m_61143_((Property)ROTATION)).intValue(), 16)));
    }

    @NotNull
    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return (BlockState)blockState.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(mirror.m_54843_(((Integer)blockState.m_61143_((Property)ROTATION)).intValue(), 16)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ROTATION});
    }

    @NotNull
    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (direction == Direction.DOWN && !blockState.m_60710_((LevelReader)levelAccessor, blockPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public ResourceLocation getRenderTexture() {
        if (this == ObjectRegistry.WOLF_TRAPPER_BANNER.get()) {
            return new ResourceLocation("wildernature", "textures/banner/wolf_trapper.png");
        }
        if (this == ObjectRegistry.BUNNY_STALKER_BANNER.get()) {
            return new ResourceLocation("wildernature", "textures/banner/rabbit_hunter.png");
        }
        if (this == ObjectRegistry.BUNNY_STALKER_WALL_BANNER.get()) {
            return new ResourceLocation("wildernature", "textures/banner/rabbit_hunter.png");
        }
        if (this == ObjectRegistry.COD_CATCHER_BANNER.get()) {
            return new ResourceLocation("wildernature", "textures/banner/cod_catcher.png");
        }
        if (this == ObjectRegistry.COD_CATCHER_WALL_BANNER.get()) {
            return new ResourceLocation("wildernature", "textures/banner/cod_catcher.png");
        }
        return new ResourceLocation("wildernature", "textures/banner/wolf_trapper.png");
    }
}

