/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.util;

import dev.architectury.injectables.annotations.PlatformOnly;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.satisfy.vinery.platform.PlatformHelper;

public class WineYears {
    public static final int YEARS_START = 0;
    public static final int MAX_LEVEL = PlatformHelper.getWineMaxLevel();
    public static final int START_DURATION = PlatformHelper.getWineStartDuration();
    public static final int DURATION_PER_YEAR = PlatformHelper.getWineDurationPerYear();
    public static final int DAYS_PER_YEAR = PlatformHelper.getWineDaysPerYear();
    public static final int YEARS_PER_EFFECT_LEVEL = PlatformHelper.getWineYearsPerEffectLevel();
    public static final int MAX_DURATION = PlatformHelper.getWineMaxDuration();
    public static final String TAG_YEAR = "Year";
    public static final String TAG_EFFECT_LEVEL = "EffectAmplifier";
    public static final String TAG_EFFECT_DURATION = "EffectDuration";

    public static int getYear(Level world) {
        return world != null ? 0 + (int)(world.m_46467_() / 24000L / (long)DAYS_PER_YEAR) : 0;
    }

    public static int getDays(Level world) {
        return 0 * DAYS_PER_YEAR + (world != null ? (int)(world.m_46467_() / 24000L) : 0);
    }

    public static int getEffectLevel(ItemStack wine, Level world) {
        if (wine.m_41784_().m_128441_(TAG_EFFECT_LEVEL)) {
            return wine.m_41784_().m_128451_(TAG_EFFECT_LEVEL);
        }
        int calculated = Math.max(0, Math.min(MAX_LEVEL, WineYears.getWineAge(wine, world) / YEARS_PER_EFFECT_LEVEL));
        wine.m_41784_().m_128405_(TAG_EFFECT_LEVEL, calculated);
        return calculated;
    }

    public static int getWineAge(ItemStack wine, Level world) {
        return WineYears.getYear(world) - (!WineYears.hasWineYear(wine) ? WineYears.getWineYear(wine) : 0);
    }

    public static int getWineAgeDays(ItemStack wine, Level world) {
        return WineYears.getDays(world) - (!WineYears.hasWineYear(wine) ? WineYears.getWineYear(wine) : 0) * DAYS_PER_YEAR;
    }

    public static void setWineYear(ItemStack wine, Level world) {
        int year = world != null ? WineYears.getYear(world) : 0;
        wine.m_41784_().m_128405_(TAG_YEAR, year);
        int age = WineYears.getYear(world) - year;
        int amplifier = Math.max(0, Math.min(MAX_LEVEL, age / YEARS_PER_EFFECT_LEVEL));
        int duration = Math.min(START_DURATION + DURATION_PER_YEAR * age, MAX_DURATION);
        wine.m_41784_().m_128405_(TAG_EFFECT_LEVEL, amplifier);
        wine.m_41784_().m_128405_(TAG_EFFECT_DURATION, duration);
    }

    public static int getWineYear(ItemStack wine) {
        return wine.m_41784_().m_128451_(TAG_YEAR);
    }

    public static int getEffectDuration(ItemStack wine, Level world) {
        if (wine.m_41784_().m_128441_(TAG_EFFECT_DURATION)) {
            return wine.m_41784_().m_128451_(TAG_EFFECT_DURATION);
        }
        int age = WineYears.getWineAge(wine, world);
        int calculated = Math.min(START_DURATION + DURATION_PER_YEAR * age, MAX_DURATION);
        wine.m_41784_().m_128405_(TAG_EFFECT_DURATION, calculated);
        return calculated;
    }

    public static boolean hasWineYear(ItemStack wine) {
        return !wine.m_41784_().m_128441_(TAG_YEAR);
    }

    @PlatformOnly(value={"forge"})
    public static CompoundTag getShareTag(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41783_() != null) {
            if (stack.m_41783_().m_128441_(TAG_YEAR)) {
                tag.m_128405_(TAG_YEAR, stack.m_41783_().m_128451_(TAG_YEAR));
            }
            if (stack.m_41783_().m_128441_(TAG_EFFECT_LEVEL)) {
                tag.m_128405_(TAG_EFFECT_LEVEL, stack.m_41783_().m_128451_(TAG_EFFECT_LEVEL));
            }
            if (stack.m_41783_().m_128441_(TAG_EFFECT_DURATION)) {
                tag.m_128405_(TAG_EFFECT_DURATION, stack.m_41783_().m_128451_(TAG_EFFECT_DURATION));
            }
        }
        return tag;
    }

    @PlatformOnly(value={"forge"})
    public static void readShareTag(ItemStack stack, CompoundTag nbt) {
        if (nbt != null) {
            if (nbt.m_128441_(TAG_YEAR)) {
                stack.m_41784_().m_128405_(TAG_YEAR, nbt.m_128451_(TAG_YEAR));
            }
            if (nbt.m_128441_(TAG_EFFECT_LEVEL)) {
                stack.m_41784_().m_128405_(TAG_EFFECT_LEVEL, nbt.m_128451_(TAG_EFFECT_LEVEL));
            }
            if (nbt.m_128441_(TAG_EFFECT_DURATION)) {
                stack.m_41784_().m_128405_(TAG_EFFECT_DURATION, nbt.m_128451_(TAG_EFFECT_DURATION));
            }
        }
    }
}

