/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.compat.jei.category;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.satisfy.vinery.core.recipe.ApplePressFermentingRecipe;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;

public class ApplePressFermentingCategory
implements IRecipeCategory<ApplePressFermentingRecipe> {
    public static final RecipeType<ApplePressFermentingRecipe> APPLE_PRESS_TYPE = RecipeType.create((String)"vinery", (String)"apple_press_fermenting", ApplePressFermentingRecipe.class);
    private static final int BACKGROUND_WIDTH = 160;
    private static final int BACKGROUND_HEIGHT = 70;
    private static final int X_OFFSET = 10;
    private static final int Y_OFFSET = 10;
    private static final Vector2i ARROW_POS = new Vector2i(101, 17);
    private static final int ARROW_U = 176;
    private static final int ARROW_V = 47;
    private static final int ARROW_WIDTH = 10;
    private static final int ARROW_HEIGHT = 28;
    private static final int MAX_TIME = 200;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final Component title;

    public ApplePressFermentingCategory(IGuiHelper helper) {
        ResourceLocation texture = new ResourceLocation("vinery", "textures/gui/apple_press_gui.png");
        this.background = helper.createDrawable(texture, 10, 10, 160, 70);
        this.arrow = helper.drawableBuilder(texture, 176, 47, 10, 28).buildAnimated(200, IDrawableAnimated.StartDirection.BOTTOM, false);
        ItemStack kettleStack = new ItemStack((ItemLike)ObjectRegistry.APPLE_PRESS.get());
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)kettleStack);
        this.title = ((Block)ObjectRegistry.APPLE_PRESS.get()).m_49954_();
    }

    @NotNull
    public RecipeType<ApplePressFermentingRecipe> getRecipeType() {
        return APPLE_PRESS_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ApplePressFermentingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 91, 40).addIngredients((Ingredient)recipe.m_7527_().get(0));
        assert (Minecraft.m_91087_().f_91073_ != null);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 109, 8).addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
        if (recipe.requiresBottle()) {
            ItemStack wineBottle = new ItemStack((ItemLike)ObjectRegistry.WINE_BOTTLE.get());
            builder.addSlot(RecipeIngredientRole.INPUT, 109, 40).addIngredients(Ingredient.m_43927_((ItemStack[])new ItemStack[]{wineBottle}));
        }
    }

    public void draw(ApplePressFermentingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, ARROW_POS.x() - 10, ARROW_POS.y() - 10);
    }
}

