/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block;

import com.berksire.furniture.block.LineConnectingBlock;
import com.berksire.furniture.util.FurnitureUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SofaBlock
extends LineConnectingBlock {
    public static final Map<Direction, VoxelShape> SHAPE;
    public static final Map<Direction, VoxelShape> MIDDLE_SHAPE;
    public static final Map<Direction, VoxelShape> LEFT_SHAPE;
    public static final Map<Direction, VoxelShape> RIGHT_SHAPE;
    private final DyeColor color;
    private static final Supplier<VoxelShape> noneShapeSupplier;
    private static final Supplier<VoxelShape> middleShapeSupplier;
    private static final Supplier<VoxelShape> leftShapeSupplier;
    private static final Supplier<VoxelShape> rightShapeSupplier;

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (switch ((FurnitureUtil.LineConnectingType)((Object)state.m_61143_((Property)TYPE))) {
            case FurnitureUtil.LineConnectingType.MIDDLE -> MIDDLE_SHAPE;
            case FurnitureUtil.LineConnectingType.LEFT -> LEFT_SHAPE;
            case FurnitureUtil.LineConnectingType.RIGHT -> RIGHT_SHAPE;
            default -> SHAPE;
        }).get(state.m_61143_((Property)FACING));
    }

    public SofaBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return FurnitureUtil.onUse(world, player, hand, hit, 0.0);
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.m_142072_(world, state, pos, entity, fallDistance * 0.5f);
    }

    public void m_5548_(BlockGetter world, Entity entity) {
        if (entity.m_20162_()) {
            super.m_5548_(world, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    private void bounceUp(Entity entity) {
        Vec3 motion = entity.m_20184_();
        if (motion.f_82480_ < 0.0) {
            double bounceFactor = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(motion.f_82479_, -motion.f_82480_ * 0.66 * bounceFactor, motion.f_82481_);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        FurnitureUtil.onStateReplaced(world, pos);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    static {
        noneShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.4375, (double)0.75, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.375, (double)0.003125, (double)1.0625, (double)0.75, (double)0.99375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.0625, (double)0.375, (double)0.003125, (double)0.1875, (double)0.75, (double)0.99375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.125, (double)0.0, (double)1.0, (double)0.4375, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.0, (double)0.0625, (double)0.9375, (double)0.125, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.1875, (double)0.125, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.0, (double)0.8125, (double)0.9375, (double)0.125, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.8125, (double)0.1875, (double)0.125, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            return shape;
        };
        middleShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.4375, (double)0.75, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.125, (double)0.0, (double)1.0, (double)0.4375, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
            return shape;
        };
        leftShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.4375, (double)0.75, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.375, (double)0.003125, (double)0.25, (double)0.75, (double)0.99375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.125, (double)0.0, (double)1.0, (double)0.4375, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.0625, (double)0.3125, (double)0.125, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.8125, (double)0.3125, (double)0.125, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            return shape;
        };
        rightShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.4375, (double)0.75, (double)0.875, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.375, (double)0.003125, (double)1.0, (double)0.75, (double)0.99375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.125, (double)0.0, (double)0.875, (double)0.4375, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.6875, (double)0.0, (double)0.0625, (double)0.8125, (double)0.125, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.6875, (double)0.0, (double)0.8125, (double)0.8125, (double)0.125, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            return shape;
        };
        SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
                map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, noneShapeSupplier.get()));
            }
        });
        MIDDLE_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
                map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, middleShapeSupplier.get()));
            }
        });
        LEFT_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
                map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, leftShapeSupplier.get()));
            }
        });
        RIGHT_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
                map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, rightShapeSupplier.get()));
            }
        });
    }
}

