/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block;

import com.berksire.furniture.block.FacingBlock;
import com.berksire.furniture.block.entity.ClockBlockEntity;
import com.berksire.furniture.registry.SoundRegistry;
import com.berksire.furniture.util.FurnitureUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClockBlock
extends FacingBlock
implements EntityBlock {
    private final WoodType woodType;
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.21875, (double)0.21875, (double)0.875, (double)0.78125, (double)0.78125, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.46875, (double)0.46875, (double)0.84375, (double)0.53125, (double)0.53125, (double)0.90625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });

    public ClockBlock(BlockBehaviour.Properties settings, WoodType woodType) {
        super(settings);
        this.woodType = woodType;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)f_54117_));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        BlockState blockState = world.m_8055_(blockPos);
        return blockState.m_60783_((BlockGetter)world, blockPos, direction);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction[] placementDirections;
        BlockState blockState = this.m_49966_();
        Level worldView = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        for (Direction direction : placementDirections = ctx.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(blockState = (BlockState)blockState.m_61124_((Property)f_54117_, (Comparable)direction.m_122424_())).m_60710_((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ClockBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public WoodType getWoodType() {
        return this.woodType;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        world.m_5594_(null, pos, (SoundEvent)SoundRegistry.GRANDFATHERS_CLOCK_TICKING.get(), SoundSource.BLOCKS, 0.15f, 1.0f);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_) {
            long time = world.m_46468_();
            int hours = (int)((time / 1000L + 6L) % 24L);
            int minutes = (int)(60L * (time % 1000L) / 1000L);
            player.m_5661_((Component)Component.m_237110_((String)"tooltip.furniture.clock", (Object[])new Object[]{String.format(Locale.ENGLISH, "%02d:%02d", hours, minutes)}), true);
        }
        return InteractionResult.SUCCESS;
    }

    public static enum WoodType {
        OAK,
        SPRUCE,
        BIRCH,
        JUNGLE,
        ACACIA,
        DARK_OAK,
        MANGROVE,
        CHERRY;

    }
}

