/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block;

import com.berksire.furniture.block.entity.ChimneyBlockEntity;
import com.berksire.furniture.util.FurnitureUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChimneyBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<FurnitureUtil.SmokeType> SMOKE_TYPE = EnumProperty.m_61587_((String)"smoke_type", FurnitureUtil.SmokeType.class);
    public static final BooleanProperty SOOTY = BooleanProperty.m_61465_((String)"sooty");
    private static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0), (VoxelShape)Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));

    public ChimneyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(SMOKE_TYPE, (Comparable)((Object)FurnitureUtil.SmokeType.NO_SMOKE))).m_61124_((Property)SOOTY, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SMOKE_TYPE, SOOTY});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_(SMOKE_TYPE, (Comparable)((Object)FurnitureUtil.SmokeType.SMOKE))).m_61124_((Property)SOOTY, (Comparable)Boolean.valueOf(false));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_ && hand == InteractionHand.MAIN_HAND) {
            if (player.m_21120_(hand).m_41720_() == Items.f_271356_ && ((Boolean)state.m_61143_((Property)SOOTY)).booleanValue()) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)SOOTY, (Comparable)Boolean.valueOf(false)), 3);
                world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, Items.f_42498_.m_7968_()));
                for (int i = 0; i < 5; ++i) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_175828_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 0.0, 0.1, 0.0);
                }
                return InteractionResult.SUCCESS;
            }
            if (player.m_6144_()) {
                FurnitureUtil.SmokeType currentType = (FurnitureUtil.SmokeType)((Object)state.m_61143_(SMOKE_TYPE));
                FurnitureUtil.SmokeType newType = currentType.getNext();
                world.m_7731_(pos, (BlockState)state.m_61124_(SMOKE_TYPE, (Comparable)((Object)newType)), 3);
                player.m_5661_((Component)Component.m_237110_((String)"tooltip.furniture.smoke_type", (Object[])new Object[]{Component.m_237115_((String)newType.getTranslationKey())}), true);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        int i;
        FurnitureUtil.SmokeType smokeType = (FurnitureUtil.SmokeType)((Object)state.m_61143_(SMOKE_TYPE));
        boolean isSooty = (Boolean)state.m_61143_((Property)SOOTY);
        if (smokeType == FurnitureUtil.SmokeType.HEAVY_SMOKE) {
            for (i = 0; i < 10; ++i) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123777_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 0.0, 0.1, 0.0);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123778_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 0.0, 0.1, 0.0);
            }
        } else if (smokeType == FurnitureUtil.SmokeType.SMOKE) {
            for (i = 0; i < 5; ++i) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123777_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 0.0, 0.1, 0.0);
            }
        }
        if (isSooty) {
            for (i = 0; i < 5; ++i) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 0.0, 0.1, 0.0);
            }
        }
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ChimneyBlockEntity(pos, state);
    }

    @Nullable
    public <E extends BlockEntity> BlockEntityTicker<E> m_142354_(Level level, BlockState state, BlockEntityType<E> blockEntityType) {
        return level.f_46443_ ? null : (lvl, pos, blockState, t) -> {
            if (t instanceof ChimneyBlockEntity) {
                ChimneyBlockEntity.tick(lvl, pos, blockState);
            }
        };
    }
}

