/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block;

import com.berksire.furniture.registry.ObjectRegistry;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BinBlock
extends Block {
    public static final IntegerProperty FILL_STAGE = IntegerProperty.m_61631_((String)"fill_stage", (int)0, (int)11);
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.9375, (double)0.875);
    private static final Random RANDOM = new Random();
    private static final double BAG_DROP_PROBABILITY = 0.25;

    public BinBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FILL_STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FILL_STAGE});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        if (!heldItem.m_41619_()) {
            int currentFillStage = (Integer)state.m_61143_((Property)FILL_STAGE);
            if (currentFillStage < 11) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)FILL_STAGE, (Comparable)Integer.valueOf(currentFillStage + 1)), 3);
                world.m_5594_(null, pos, SoundEvents.f_11765_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (currentFillStage >= 9) {
                    this.spawnParticles(world, pos);
                }
            } else {
                world.m_5594_(null, pos, SoundEvents.f_11766_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (RANDOM.nextDouble() < 0.25) {
                    this.dropItem(world, pos);
                }
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)FILL_STAGE, (Comparable)Integer.valueOf(0)), 3);
            }
            if (!player.m_150110_().f_35937_) {
                heldItem.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void dropItem(Level world, BlockPos pos) {
        ItemStack droppedItem = new ItemStack((ItemLike)ObjectRegistry.TRASH_BAG.get());
        Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)droppedItem);
    }

    private void spawnParticles(Level world, BlockPos pos) {
        for (int i = 0; i < 20; ++i) {
            double offsetX = RANDOM.nextDouble() * 0.6 - 0.3;
            double offsetY = RANDOM.nextDouble() * 0.6 - 0.3;
            double offsetZ = RANDOM.nextDouble() * 0.6 - 0.3;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_() + 1.0 + offsetY, (double)pos.m_123343_() + 0.5 + offsetZ, 0.0, 1.0, 0.0);
        }
    }
}

