/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.satisfy.farm_and_charm.block.entity.WaterSprinklerBlockEntity;
import net.satisfy.farm_and_charm.client.model.WaterSprinklerModel;
import org.joml.Quaternionf;

public class WaterSprinklerRenderer
implements BlockEntityRenderer<WaterSprinklerBlockEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("farm_and_charm", "textures/entity/water_sprinkler.png");
    private final ModelPart rotating;
    private final ModelPart basin;
    private long lastRenderTime = 0L;
    private float rotationAngle = 0.0f;

    public WaterSprinklerRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart root = context.m_173582_(WaterSprinklerModel.LAYER_LOCATION);
        this.rotating = root.m_171324_("rotating");
        this.basin = root.m_171324_("basin");
    }

    private float updateRotationAngle(WaterSprinklerBlockEntity blockEntity) {
        Level level = blockEntity.m_58904_();
        assert (level != null);
        boolean isRaining = level.m_46471_();
        boolean isThundering = level.m_46470_();
        float rotationSpeed = isRaining || isThundering ? 2.0f : 1.0f;
        long currentTime = System.currentTimeMillis();
        if (this.lastRenderTime == 0L) {
            this.lastRenderTime = currentTime;
        }
        float deltaTime = (float)(currentTime - this.lastRenderTime) / 1000.0f;
        this.lastRenderTime = currentTime;
        this.rotationAngle += rotationSpeed * deltaTime * 40.0f;
        this.rotationAngle %= 360.0f;
        blockEntity.setRotationAngle(this.rotationAngle);
        return this.rotationAngle;
    }

    public void render(WaterSprinklerBlockEntity blockEntity, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)TEXTURE));
        matrixStack.m_85836_();
        float angle = this.updateRotationAngle(blockEntity);
        matrixStack.m_85837_(0.5, 0.0, 0.5);
        matrixStack.m_252781_(new Quaternionf().rotationY((float)Math.toRadians(-angle)));
        matrixStack.m_85837_(-0.5, 0.0, -0.5);
        this.rotating.m_104301_(matrixStack, vertexConsumer, combinedLight, OverlayTexture.f_118083_);
        matrixStack.m_85849_();
        this.basin.m_104301_(matrixStack, vertexConsumer, combinedLight, OverlayTexture.f_118083_);
    }
}

